/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.texboobcat.worldManager.HelpCommand;
import org.texboobcat.worldManager.WorldCommand;
import org.texboobcat.worldManager.api.WorldAPI;
import org.texboobcat.worldManager.integration.WorldManagerExpansion;
import org.texboobcat.worldManager.listener.ChatListener;
import org.texboobcat.worldManager.listener.GuiListener;
import org.texboobcat.worldManager.listener.WorldRulesListener;
import org.texboobcat.worldManager.model.ManagedWorld;
import org.texboobcat.worldManager.service.WorldRegistry;
import org.texboobcat.worldManager.task.WorldImportTask;

public final class WorldManager
extends JavaPlugin
implements WorldAPI {
    private WorldRegistry registry;
    private final Map<UUID, Long> lastTeleportAt = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Location> lastLocation = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Set<String>> favorites = new ConcurrentHashMap<UUID, Set<String>>();
    private final Map<UUID, Deque<Location>> history = new ConcurrentHashMap<UUID, Deque<Location>>();
    private final Map<UUID, Integer> guiPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Boolean> guiFavOnly = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, GuiMode> guiMode = new ConcurrentHashMap<UUID, GuiMode>();
    private final Map<UUID, PendingCreate> pendingCreate = new ConcurrentHashMap<UUID, PendingCreate>();
    private final Map<String, WorldImportTask> runningImports = new ConcurrentHashMap<String, WorldImportTask>();

    public void onEnable() {
        this.saveDefaultConfig();
        try {
            MergeInfo info = this.mergeConfigWithBackup();
            if (info.changed) {
                this.getLogger().info("Config merged: version " + info.fromVersion + " -> " + info.toVersion + ", added " + info.addedKeys + " keys.");
            } else {
                this.getLogger().info("Config up-to-date (version " + info.toVersion + ")");
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to update/merge config.yml: " + e.getMessage());
        }
        this.registry = new WorldRegistry(this);
        this.registry.load();
        try {
            boolean autoCleanup;
            ConfigurationSection qsec = this.getConfig().getConfigurationSection("options.delete_trash");
            boolean bl = autoCleanup = qsec != null && qsec.getBoolean("auto_cleanup_on_start", true);
            if (autoCleanup) {
                File[] files;
                int minutes = Math.max(1, qsec.getInt("retention_minutes", 120));
                long now = System.currentTimeMillis();
                long ttlMs = (long)minutes * 60L * 1000L;
                File trashDir = new File(Bukkit.getWorldContainer(), "trash");
                if (trashDir.isDirectory() && (files = trashDir.listFiles((d, n) -> n != null && n.toLowerCase(Locale.ROOT).endsWith(".zip"))) != null) {
                    for (File f : files) {
                        long age = now - f.lastModified();
                        if (age <= ttlMs) continue;
                        try {
                            Files.deleteIfExists(f.toPath());
                            this.getLogger().info("Purged expired trash zip: " + f.getName());
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Failed to purge trash zip '" + f.getName() + "': " + e.getMessage());
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            this.getLogger().warning("Trash zip auto-cleanup encountered an error: " + t.getMessage());
        }
        if (this.getConfig().getBoolean("options.autoload_registered_worlds", true)) {
            try {
                for (ManagedWorld mw : this.registry.all()) {
                    File folder;
                    String name = mw.getName();
                    if (name == null || name.isBlank() || Bukkit.getWorld((String)name) != null || !(folder = new File(Bukkit.getWorldContainer(), name)).exists() || !folder.isDirectory()) continue;
                    World.Environment env = World.Environment.NORMAL;
                    if (new File(folder, "DIM-1").isDirectory()) {
                        env = World.Environment.NETHER;
                    } else if (new File(folder, "DIM1").isDirectory()) {
                        env = World.Environment.THE_END;
                    }
                    WorldCreator creator = new WorldCreator(name).environment(env);
                    World w = Bukkit.createWorld((WorldCreator)creator);
                    if (w != null) {
                        mw.applyToWorldIfLoaded();
                        this.getLogger().info("Auto-loaded world '" + name + "' (" + env.name() + ")");
                        continue;
                    }
                    this.getLogger().warning("Failed to auto-load world '" + name + "'");
                }
            }
            catch (Throwable t) {
                this.getLogger().warning("Auto-load of registered worlds encountered an error: " + t.getMessage());
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)new WorldRulesListener(this, this.registry), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        WorldCommand worldCommand = new WorldCommand(this);
        if (this.getCommand("world") != null) {
            this.getCommand("world").setExecutor((CommandExecutor)worldCommand);
            this.getCommand("world").setTabCompleter((TabCompleter)worldCommand);
        } else {
            this.getLogger().severe("Command 'world' is not defined in plugin.yml");
        }
        if (this.getCommand("wm") != null) {
            this.getCommand("wm").setExecutor((CommandExecutor)worldCommand);
            this.getCommand("wm").setTabCompleter((TabCompleter)worldCommand);
        } else {
            this.getLogger().warning("Command alias 'wm' is not defined in plugin.yml (optional)");
        }
        HelpCommand helpCommand = new HelpCommand(this);
        if (this.getCommand("mwhelp") != null) {
            this.getCommand("mwhelp").setExecutor((CommandExecutor)helpCommand);
            this.getCommand("mwhelp").setTabCompleter((TabCompleter)helpCommand);
        } else {
            this.getLogger().warning("Command 'mwhelp' is not defined in plugin.yml (optional)");
        }
        ServicesManager sm = this.getServer().getServicesManager();
        sm.register(WorldAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                new WorldManagerExpansion(this).register();
                this.getLogger().info("Registered PlaceholderAPI expansion 'worldmanager'.");
            }
            catch (Throwable t) {
                this.getLogger().warning("Failed to register PlaceholderAPI expansion: " + t.getMessage());
            }
        }
    }

    public void onDisable() {
        if (this.registry != null) {
            this.registry.save();
        }
        Bukkit.getServicesManager().unregister(WorldAPI.class, (Object)this);
    }

    public WorldRegistry getRegistry() {
        return this.registry;
    }

    public Map<UUID, Long> getLastTeleportAt() {
        return this.lastTeleportAt;
    }

    public Map<UUID, Location> getLastLocation() {
        return this.lastLocation;
    }

    public Set<String> getFavorites(UUID uuid) {
        return this.favorites.computeIfAbsent(uuid, k -> new ConcurrentSkipListSet(String.CASE_INSENSITIVE_ORDER));
    }

    public Deque<Location> getHistory(UUID uuid) {
        return this.history.computeIfAbsent(uuid, k -> new ArrayDeque());
    }

    public void pushHistory(UUID uuid, Location loc, int maxSize) {
        if (loc == null) {
            return;
        }
        Deque<Location> dq = this.getHistory(uuid);
        dq.addFirst(loc.clone());
        while (dq.size() > Math.max(1, maxSize)) {
            dq.removeLast();
        }
    }

    public int getGuiPage(UUID uuid) {
        return this.guiPage.getOrDefault(uuid, 0);
    }

    public void setGuiPage(UUID uuid, int page) {
        this.guiPage.put(uuid, Math.max(0, page));
    }

    public boolean isGuiFavOnly(UUID uuid) {
        return this.guiFavOnly.getOrDefault(uuid, false);
    }

    public void setGuiFavOnly(UUID uuid, boolean favOnly) {
        this.guiFavOnly.put(uuid, favOnly);
    }

    public GuiMode getGuiMode(UUID uuid) {
        return this.guiMode.getOrDefault(uuid, GuiMode.LOADED);
    }

    public void setGuiMode(UUID uuid, GuiMode mode) {
        this.guiMode.put(uuid, mode == null ? GuiMode.LOADED : mode);
    }

    public PendingCreate getPendingCreate(UUID uuid) {
        return this.pendingCreate.get(uuid);
    }

    public void setPendingCreate(UUID uuid, PendingCreate pc) {
        if (pc == null) {
            this.pendingCreate.remove(uuid);
        } else {
            this.pendingCreate.put(uuid, pc);
        }
    }

    public Map<String, WorldImportTask> getRunningImports() {
        return this.runningImports;
    }

    public boolean canAccessWorld(Player player, String worldName) {
        boolean useFmt;
        ConfigurationSection rule;
        if (player == null || worldName == null) {
            return true;
        }
        FileConfiguration cfg = this.getConfig();
        ConfigurationSection psec = cfg.getConfigurationSection("permissions");
        if (psec == null) {
            return true;
        }
        String bypass = psec.getString("bypass", "worldmanager.bypass.worldaccess");
        if (bypass != null && !bypass.isBlank() && player.hasPermission(bypass)) {
            return true;
        }
        ConfigurationSection worldsSec = psec.getConfigurationSection("worlds_access");
        if (worldsSec != null && (rule = worldsSec.getConfigurationSection(worldName)) != null) {
            ConfigurationSection presetsSec;
            String preset = rule.getString("preset", null);
            if (preset != null && (presetsSec = psec.getConfigurationSection("presets")) != null && presetsSec.isList(preset)) {
                List reqs = presetsSec.getStringList(preset);
                for (String node : reqs) {
                    if (node == null || node.isBlank() || player.hasPermission(node)) continue;
                    return false;
                }
                return true;
            }
            String require = rule.getString("require", null);
            if (require != null && !require.isBlank()) {
                return player.hasPermission(require);
            }
        }
        if (useFmt = psec.getBoolean("use_node_format", true)) {
            String fmt = psec.getString("node_format", "worldmanager.access.%world%");
            String node = fmt.replace("%world%", worldName);
            return player.hasPermission(node);
        }
        return true;
    }

    @Override
    public ManagedWorld getWorld(String name) {
        return this.registry != null ? this.registry.get(name) : null;
    }

    @Override
    public void teleportPlayer(Player p, String worldName) {
        World world = this.getServer().getWorld(worldName);
        if (world != null) {
            p.teleportAsync(world.getSpawnLocation());
        }
    }

    public MergeInfo mergeConfigWithBackup() throws Exception {
        boolean changed;
        boolean versionChanged;
        File configFile = new File(this.getDataFolder(), "config.yml");
        YamlConfiguration current = YamlConfiguration.loadConfiguration((File)configFile);
        InputStream in = this.getResource("config.yml");
        if (in == null) {
            return new MergeInfo(0, 0, 0, false);
        }
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        int currentVer = current.getInt("config_version", 0);
        int defaultVer = defaults.getInt("config_version", 1);
        int[] added = new int[1];
        this.mergeSectionsCountAdds((FileConfiguration)current, (ConfigurationSection)defaults, null, added);
        boolean bl = versionChanged = currentVer != defaultVer;
        if (versionChanged) {
            current.set("config_version", (Object)defaultVer);
        }
        boolean bl2 = changed = added[0] > 0 || versionChanged;
        if (!changed) {
            return new MergeInfo(currentVer, defaultVer, 0, false);
        }
        File backupDir = new File(this.getDataFolder(), "config-backups");
        if (!backupDir.isDirectory() && !backupDir.mkdirs()) {
            this.getLogger().warning("Could not create backup directory: " + backupDir.getAbsolutePath());
        }
        String ts = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
        Path backup = new File(backupDir, "config-" + ts + ".yml").toPath();
        try {
            Files.copy(configFile.toPath(), backup, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to backup config.yml: " + e.getMessage());
        }
        current.save(configFile);
        this.reloadConfig();
        return new MergeInfo(currentVer, defaultVer, added[0], true);
    }

    private void mergeSectionsCountAdds(FileConfiguration target, ConfigurationSection defaults, String path, int[] addedCounter) {
        for (String key : defaults.getKeys(false)) {
            String full = path == null || path.isEmpty() ? key : path + "." + key;
            Object defVal = defaults.get(key);
            if (defVal instanceof ConfigurationSection) {
                ConfigurationSection defSec = defaults.getConfigurationSection(key);
                if (!target.isConfigurationSection(full)) {
                    target.createSection(full);
                }
                if (defSec == null) continue;
                this.mergeSectionsCountAdds(target, defSec, full, addedCounter);
                continue;
            }
            if (target.contains(full)) continue;
            target.set(full, defVal);
            addedCounter[0] = addedCounter[0] + 1;
        }
    }

    public static class MergeInfo {
        public final int fromVersion;
        public final int toVersion;
        public final int addedKeys;
        public final boolean changed;

        public MergeInfo(int fromVersion, int toVersion, int addedKeys, boolean changed) {
            this.fromVersion = fromVersion;
            this.toVersion = toVersion;
            this.addedKeys = addedKeys;
            this.changed = changed;
        }
    }

    public static enum GuiMode {
        LOADED,
        LOADABLES,
        CREATE_ENV,
        CREATE_OPTIONS;

    }

    public static class PendingCreate {
        public World.Environment env;
        public Long seed;
        public Boolean structures;
        public String generator;
        public String type;
        public long expiresAt;
        public Stage stage = Stage.NONE;

        public static enum Stage {
            NONE,
            NAME,
            SEED,
            GENERATOR;

        }
    }
}

