/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.listener;

import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.texboobcat.worldManager.WorldManager;
import org.texboobcat.worldManager.model.ManagedWorld;
import org.texboobcat.worldManager.service.WorldRegistry;

public class WorldRulesListener
implements Listener {
    private final WorldRegistry registry;
    private final WorldManager plugin;

    public WorldRulesListener(WorldManager plugin, WorldRegistry registry) {
        this.plugin = plugin;
        this.registry = registry;
    }

    private ManagedWorld getMW(World w) {
        return this.registry.get(w.getName());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        this.applyGamemode(p);
        this.applyResourcePack(p);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        Player p = e.getPlayer();
        this.applyGamemode(p);
        this.applyResourcePack(p);
    }

    private void applyGamemode(Player p) {
        ManagedWorld mw = this.getMW(p.getWorld());
        if (mw == null) {
            return;
        }
        GameMode gm = mw.getGamemode();
        if (gm != null && p.getGameMode() != gm) {
            p.setGameMode(gm);
        }
    }

    private void applyResourcePack(Player p) {
        ManagedWorld mw = this.getMW(p.getWorld());
        if (mw == null) {
            return;
        }
        String url = mw.getResourcePackUrl();
        if (url == null || url.isBlank()) {
            return;
        }
        String hex = mw.getResourcePackHash();
        byte[] hash = null;
        if (hex != null && !hex.isBlank()) {
            try {
                String h = hex.replace(" ", "");
                int len = h.length();
                if (len % 2 == 0) {
                    hash = new byte[len / 2];
                    for (int i = 0; i < len; i += 2) {
                        hash[i / 2] = (byte)Integer.parseInt(h.substring(i, i + 2), 16);
                    }
                }
            }
            catch (Exception h) {
                // empty catch block
            }
        }
        boolean required = Boolean.TRUE.equals(mw.isResourcePackRequired());
        String prompt = this.plugin.getConfig().getString("messages.resource_pack_prompt", "This world uses a resource pack.");
        try {
            if (hash != null) {
                p.setResourcePack(url, hash, prompt, required);
            } else {
                p.setResourcePack(url, prompt);
            }
        }
        catch (Throwable t) {
            p.setResourcePack(url);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        String targetWorld;
        if (e.getTo() == null || e.getFrom() == null) {
            return;
        }
        World toW = e.getTo().getWorld();
        World fromW = e.getFrom().getWorld();
        if (toW == null || fromW == null) {
            return;
        }
        if (toW == fromW) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.plugin.canAccessWorld(p, targetWorld = toW.getName())) {
            e.setCancelled(true);
            p.sendMessage(this.plugin.getConfig().getString("messages.no_world_access", "You don't have access to this world.").replace("%world%", targetWorld));
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        ManagedWorld mw = this.getMW(e.getLocation().getWorld());
        if (mw == null) {
            return;
        }
        if (!mw.getAllowedMobs().isEmpty()) {
            EntityType type = e.getEntityType();
            if (!mw.getAllowedMobs().contains(type)) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent e) {
        ManagedWorld mw = this.getMW(e.getWorld());
        if (mw != null) {
            mw.applyToWorldIfLoaded();
        }
    }

    @EventHandler
    public void onWeatherChange(WeatherChangeEvent e) {
        ManagedWorld mw = this.getMW(e.getWorld());
        if (mw == null) {
            return;
        }
        if (Boolean.TRUE.equals(mw.getLockWeather())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onThunderChange(ThunderChangeEvent e) {
        ManagedWorld mw = this.getMW(e.getWorld());
        if (mw == null) {
            return;
        }
        if (Boolean.TRUE.equals(mw.getLockWeather())) {
            e.setCancelled(true);
        }
    }
}

