/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.task;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class WorldPregenTask
implements Runnable {
    private final Plugin plugin;
    private final World world;
    private final int centerChunkX;
    private final int centerChunkZ;
    private final int radiusChunks;
    private final int chunksPerTick;
    private int x;
    private int z;
    private int layer = 0;
    private int leg = 0;
    private int steps = 1;
    private int stepCount = 0;
    private int legCount = 0;
    private long processed = 0L;
    private final long total;
    private BukkitTask task;
    private final Set<Long> visited = new HashSet<Long>();

    public WorldPregenTask(Plugin plugin, World world, int centerChunkX, int centerChunkZ, int radiusChunks, int chunksPerTick) {
        this.plugin = plugin;
        this.world = world;
        this.centerChunkX = centerChunkX;
        this.centerChunkZ = centerChunkZ;
        this.radiusChunks = Math.max(0, radiusChunks);
        this.chunksPerTick = Math.max(1, chunksPerTick);
        this.x = centerChunkX;
        this.z = centerChunkZ;
        this.total = (2L * (long)radiusChunks + 1L) * (2L * (long)radiusChunks + 1L);
    }

    public void start() {
        this.task = Bukkit.getScheduler().runTaskTimer(this.plugin, (Runnable)this, 1L, 1L);
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    @Override
    public void run() {
        int loadedThisTick = 0;
        while (loadedThisTick < this.chunksPerTick) {
            if (!this.withinRadius(this.x, this.z)) {
                if (this.advanceSpiral()) continue;
                this.plugin.getLogger().info("Pregen complete for " + this.world.getName() + ": " + this.processed + "/" + this.total + " chunks");
                this.cancel();
                return;
            }
            long key = (long)this.x << 32 ^ (long)this.z & 0xFFFFFFFFL;
            if (!this.visited.add(key)) {
                if (this.advanceSpiral()) continue;
                this.cancel();
                return;
            }
            ++this.processed;
            boolean scheduled = false;
            try {
                Method m = World.class.getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE);
                Object futureObj = m.invoke((Object)this.world, this.x, this.z);
                if (futureObj instanceof CompletableFuture) {
                    CompletableFuture fut = (CompletableFuture)futureObj;
                    fut.exceptionally(ex -> null);
                    scheduled = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!scheduled) {
                this.world.getChunkAt(this.x, this.z).load(true);
            }
            ++loadedThisTick;
            if (this.advanceSpiral()) continue;
            this.plugin.getLogger().info("Pregen complete for " + this.world.getName() + ": " + this.processed + "/" + this.total + " chunks");
            this.cancel();
            return;
        }
    }

    private boolean withinRadius(int cx, int cz) {
        return Math.abs(cx - this.centerChunkX) <= this.radiusChunks && Math.abs(cz - this.centerChunkZ) <= this.radiusChunks;
    }

    private boolean advanceSpiral() {
        if (this.processed >= this.total) {
            return false;
        }
        if (this.layer != 0 || this.leg != 0 || this.stepCount == 0) {
            // empty if block
        }
        if (this.leg == 0) {
            ++this.x;
        } else if (this.leg == 1) {
            --this.z;
        } else if (this.leg == 2) {
            --this.x;
        } else if (this.leg == 3) {
            ++this.z;
        }
        ++this.stepCount;
        if (this.stepCount >= this.steps) {
            this.stepCount = 0;
            this.leg = (this.leg + 1) % 4;
            ++this.legCount;
            if (this.legCount % 2 == 0) {
                ++this.steps;
                ++this.layer;
            }
        }
        return true;
    }
}

