/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.task;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ZipCreateTask {
    private final Plugin plugin;
    private final Path sourceDir;
    private final Path zipFile;
    private final CompletableFuture<Path> result = new CompletableFuture();

    public ZipCreateTask(Plugin plugin, Path sourceDir, Path zipFile) {
        this.plugin = plugin;
        this.sourceDir = sourceDir;
        this.zipFile = zipFile;
    }

    public void start() {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                Files.createDirectories(this.zipFile.getParent(), new FileAttribute[0]);
                try (OutputStream fos = Files.newOutputStream(this.zipFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);
                     ZipOutputStream zos = new ZipOutputStream(bos);){
                    Path base = this.sourceDir;
                    if (!Files.isDirectory(base, new LinkOption[0])) {
                        throw new IOException("Source is not a directory: " + String.valueOf(base));
                    }
                    Files.walk(base, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                        try {
                            Path rel = base.relativize((Path)p);
                            ZipEntry entry = new ZipEntry(rel.toString().replace('\\', '/'));
                            zos.putNextEntry(entry);
                            Files.copy(p, zos);
                            zos.closeEntry();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }
                this.result.complete(this.zipFile);
            }
            catch (UncheckedIOException uioe) {
                this.result.completeExceptionally(uioe.getCause());
            }
            catch (Throwable t) {
                this.result.completeExceptionally(t);
            }
        });
    }

    public CompletableFuture<Path> getResult() {
        return this.result;
    }
}

