/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.worldManager.task;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ZipExtractTask {
    private final Plugin plugin;
    private final Path zipFile;
    private final Path targetDir;
    private final CompletableFuture<Path> result = new CompletableFuture();

    public ZipExtractTask(Plugin plugin, Path zipFile, Path targetDir) {
        this.plugin = plugin;
        this.zipFile = zipFile;
        this.targetDir = targetDir;
    }

    public void start() {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try (InputStream fis = Files.newInputStream(this.zipFile, new OpenOption[0]);
                 BufferedInputStream bis = new BufferedInputStream(fis);
                 ZipInputStream zis = new ZipInputStream(bis);){
                ZipEntry entry;
                Files.createDirectories(this.targetDir, new FileAttribute[0]);
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        Files.createDirectories(this.targetDir.resolve(entry.getName()), new FileAttribute[0]);
                    } else {
                        Path out = this.targetDir.resolve(entry.getName());
                        Files.createDirectories(out.getParent(), new FileAttribute[0]);
                        try (OutputStream os = Files.newOutputStream(out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                            zis.transferTo(os);
                        }
                    }
                    zis.closeEntry();
                }
                this.result.complete(this.targetDir);
            }
            catch (Throwable t) {
                this.result.completeExceptionally(t);
            }
        });
    }

    public CompletableFuture<Path> getResult() {
        return this.result;
    }
}

