/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.trashcansforever.network;

import java.util.function.Supplier;
import net.mcreator.trashcansforever.TrashcansForeverMod;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TrashcansForeverModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TrashcansForeverMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private WorldSavedData data;

        public SavedDataSyncMessage(PacketBuffer buffer) {
            this.type = buffer.readInt();
            CompoundNBT nbt = buffer.func_150793_b();
            if (nbt != null) {
                WorldSavedData worldSavedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                if (this.data instanceof MapVariables) {
                    ((MapVariables)this.data).func_76184_a(nbt);
                } else if (this.data instanceof WorldVariables) {
                    ((WorldVariables)this.data).func_76184_a(nbt);
                }
            }
        }

        public SavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "trashcans_forever_mapvars";
        static MapVariables clientSide = new MapVariables();

        public MapVariables() {
            super(DATA_NAME);
        }

        public MapVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (world instanceof World && !world.func_201670_d()) {
                TrashcansForeverMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(IWorld world) {
            if (world instanceof IServerWorld) {
                return (MapVariables)((IServerWorld)world).func_201672_e().func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "trashcans_forever_worldvars";
        public double skipx = 0.0;
        public double skipy = 0.0;
        public double skipz = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
        }

        public WorldVariables(String s) {
            super(s);
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.skipx = nbt.func_74769_h("skipx");
            this.skipy = nbt.func_74769_h("skipy");
            this.skipz = nbt.func_74769_h("skipz");
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            nbt.func_74780_a("skipx", this.skipx);
            nbt.func_74780_a("skipy", this.skipy);
            nbt.func_74780_a("skipz", this.skipz);
            return nbt;
        }

        public void syncData(IWorld world) {
            this.func_76185_a();
            if (world instanceof World && !((World)world).func_201670_d()) {
                TrashcansForeverMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((World)((World)world)).func_234923_W_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(IWorld world) {
            if (world instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().field_70170_p.func_201670_d()) {
                MapVariables mapdata = MapVariables.get((IWorld)event.getPlayer().field_70170_p);
                WorldVariables worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p);
                if (mapdata != null) {
                    TrashcansForeverMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TrashcansForeverMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getPlayer().field_70170_p.func_201670_d() && (worlddata = WorldVariables.get((IWorld)event.getPlayer().field_70170_p)) != null) {
                TrashcansForeverMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

