/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.alldeath;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;
import tk.estecka.alldeath.AllDeathMessages;
import tk.estecka.alldeath.config.JsonConfig;
import tk.estecka.alldeath.config.StyleParser;

public class DeathStyles {
    public static final String CONFIG_FILE = "alldeath-styles.json";
    public static final List<MobStyle> STYLES = new ArrayList<MobStyle>();

    public static class_2561 getStyledName(class_1297 entity) {
        return DeathStyles.getStyledName(entity, entity.method_5476());
    }

    public static class_2561 getStyledName(class_1297 entity, class_2561 name) {
        MobStyle deathStyle = new MobStyle();
        for (MobStyle s : STYLES) {
            if (!s.predicate.test(entity)) continue;
            deathStyle.MergeWith(s);
        }
        class_2583 textStyle = name.method_10866();
        if (deathStyle.color != null) {
            textStyle = textStyle.method_27703(deathStyle.color);
        }
        if (deathStyle.bold != null) {
            textStyle = textStyle.method_10982(deathStyle.bold);
        }
        if (deathStyle.italic != null) {
            textStyle = textStyle.method_10978(deathStyle.italic);
        }
        if (deathStyle.underline != null) {
            textStyle = textStyle.method_30938(deathStyle.underline);
        }
        if (deathStyle.strike != null) {
            textStyle = textStyle.method_36140(deathStyle.strike);
        }
        if (deathStyle.cursed != null) {
            textStyle = textStyle.method_36141(deathStyle.cursed);
        }
        return name.method_27661().method_10862(textStyle);
    }

    public static boolean initialize() {
        JsonElement json;
        try {
            JsonConfig configFile = new JsonConfig(CONFIG_FILE, "alldeathmessages", AllDeathMessages.LOGGER);
            json = configFile.GetOrCreateJsonFile();
        }
        catch (JsonSyntaxException | IOException e) {
            AllDeathMessages.LOGGER.error("Unable to load config file: {}\n {}", (Object)CONFIG_FILE, (Object)e.toString());
            return false;
        }
        STYLES.addAll(StyleParser.CreateConfigFromJson(json));
        return true;
    }

    public static class MobStyle {
        public Predicate<class_1297> predicate = e -> false;
        @Nullable
        public class_5251 color = null;
        @Nullable
        public Boolean bold = null;
        @Nullable
        public Boolean italic = null;
        @Nullable
        public Boolean underline = null;
        @Nullable
        public Boolean strike = null;
        @Nullable
        public Boolean cursed = null;

        public boolean IsEmpty() {
            return this.color == null && this.bold == null && this.italic == null && this.underline == null && this.strike == null && this.cursed == null;
        }

        public MobStyle MergeWith(MobStyle bottom) {
            if (this.color == null) {
                this.color = bottom.color;
            }
            if (this.bold == null) {
                this.bold = bottom.bold;
            }
            if (this.italic == null) {
                this.italic = bottom.italic;
            }
            if (this.underline == null) {
                this.underline = bottom.underline;
            }
            if (this.strike == null) {
                this.strike = bottom.strike;
            }
            if (this.cursed == null) {
                this.cursed = bottom.cursed;
            }
            return this;
        }
    }
}

