/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.alldeath;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_6025;

public class EntityPredicates {
    public static final Map<String, Predicate<class_1297>> predicates = new LinkedHashMap<String, Predicate<class_1297>>(11){
        {
            this.put("all", e -> true);
            this.put("player", EntityPredicates::PLAYER);
            this.put("named", EntityPredicates.NonPlayer(EntityPredicates::NAMED));
            this.put("tamed", EntityPredicates.NonPlayer(EntityPredicates::TAMED));
            this.put("persistent", EntityPredicates.NonPlayer(EntityPredicates::PERSISTENT));
            this.put("hostile", EntityPredicates.NonPlayer(EntityPredicates::HOSTILE));
            this.put("passive", EntityPredicates.NonPlayer(EntityPredicates::PASSIVE));
            this.put("ephemeral", EntityPredicates.NonPlayer(EntityPredicates::EPHEMERAL));
            this.put("semi-persistent", EntityPredicates.NonPlayer(EntityPredicates::SEMIPERSISTENT));
        }
    };

    private static Predicate<class_1297> NonPlayer(Predicate<class_1297> base) {
        return e -> !EntityPredicates.PLAYER(e) && base.test((class_1297)e);
    }

    public static boolean PLAYER(class_1297 e) {
        return e instanceof class_1657;
    }

    public static boolean NAMED(class_1297 e) {
        return e.method_16914();
    }

    public static boolean TAMED(class_1297 entity) {
        class_6025 tameable;
        return entity instanceof class_6025 && (tameable = (class_6025)entity).method_66287() != null;
    }

    public static boolean HOSTILE(class_1297 e) {
        class_1308 mob;
        return e instanceof class_1308 && !(mob = (class_1308)e).method_5864().method_72390();
    }

    public static boolean PASSIVE(class_1297 e) {
        return !EntityPredicates.HOSTILE(e);
    }

    public static boolean EPHEMERAL(class_1297 e) {
        return !EntityPredicates.PERSISTENT(e);
    }

    public static boolean SEMIPERSISTENT(class_1297 e) {
        class_1308 mob;
        return e instanceof class_1308 && (mob = (class_1308)e).method_17326();
    }

    public static boolean PERSISTENT(class_1297 entity) {
        if (entity instanceof class_1528 || entity instanceof class_1510) {
            return true;
        }
        if (!(entity instanceof class_1308)) {
            return false;
        }
        class_1308 mob = (class_1308)entity;
        return mob.method_5947() || !mob.method_5974(Double.POSITIVE_INFINITY);
    }

    public static Predicate<class_1297> getOrDefault(String name) {
        return predicates.getOrDefault(name, e -> false);
    }

    public static Predicate<class_1297> put(String name, Predicate<class_1297> p) {
        return predicates.put(name, p);
    }
}

