/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.alldeath.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.slf4j.Logger;

public class JsonConfig {
    public final String filename;
    public final Path path;
    public final File file;
    private final Logger logger;
    private ModContainer mod = null;
    private Path pathToDefault = null;

    public JsonConfig(String filename, String modId, Logger logger) {
        this.filename = filename;
        FabricLoader loader = FabricLoader.getInstance();
        this.logger = logger;
        this.path = loader.getConfigDir().resolve(filename);
        this.file = this.path.toFile();
        Optional optMod = loader.getModContainer(modId);
        if (optMod.isEmpty()) {
            this.logger.error("{} is not a valid mod id", (Object)modId);
        } else {
            this.mod = (ModContainer)optMod.get();
            Optional optPath = this.mod.findPath("config/" + filename);
            if (optPath.isPresent()) {
                this.pathToDefault = (Path)optPath.get();
            }
        }
    }

    public JsonElement GetOrCreateJsonFile() throws IOException {
        if (!this.file.exists()) {
            this.CreateFileFromDefault();
            this.logger.info("Automatically created new config file {}", (Object)this.filename);
        }
        return this.GetJsonFromFile();
    }

    public JsonElement GetJsonFromFile() throws FileNotFoundException {
        FileInputStream cin = new FileInputStream(this.file);
        InputStreamReader reader = new InputStreamReader(cin);
        JsonElement json = JsonParser.parseReader((Reader)reader);
        return json;
    }

    public boolean CreateFileFromDefault() throws IOException {
        if (this.pathToDefault == null) {
            this.logger.error("No default file was found for {}", (Object)this.filename);
            throw new FileNotFoundException();
        }
        Path src = this.pathToDefault;
        Path dst = this.path;
        Files.copy(src, dst, StandardCopyOption.COPY_ATTRIBUTES);
        return true;
    }
}

