/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.alldeath.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import tk.estecka.alldeath.AllDeathMessages;
import tk.estecka.alldeath.TypeEntityPredicate;
import tk.estecka.alldeath.config.PredicateParser;

public class RuleParser {
    public static HashMap<String, Predicate<class_1297>> CreateConfigFromJson(JsonElement json) {
        HashMap<String, Predicate<class_1297>> config = new HashMap<String, Predicate<class_1297>>();
        Gson gson = new Gson();
        if (!json.isJsonObject()) {
            AllDeathMessages.LOGGER.error("Rule config root is not a Json Object");
            return null;
        }
        JsonObject root = json.getAsJsonObject();
        for (String ruleName : root.keySet()) {
            TypeEntityPredicate rule = PredicateParser.CreateTypePredicateFromJson(root.get(ruleName), gson);
            if (rule == null) {
                AllDeathMessages.LOGGER.error("Invalid rule \"{}\"", (Object)ruleName);
                continue;
            }
            if (rule.IsEmpty()) {
                AllDeathMessages.LOGGER.warn("Rule \"{}\" contains no valid predicate and will be ignored", (Object)ruleName);
                continue;
            }
            config.put(ruleName, rule);
        }
        return config;
    }
}

