/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.alldeath;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import tk.estecka.alldeath.AllDeathMessages;
import tk.estecka.alldeath.DeathRules;
import tk.estecka.alldeath.DeathStyles;
import tk.estecka.alldeath.EntityPredicates;

public class Commands {
    public static final class_2960 ID = class_2960.method_60655((String)"alldeath", (String)"command");
    private static final String ENTITY_ARG = "entity";
    private static final String RULENAME_ARG = "rule name";
    private static final String RULETYPE_ARG = "rule type";
    private static final String BOOL_ARG = "boolean";
    private static final String CONFIRM_ARG = "confirm";

    public static void Register() {
        CommandRegistrationCallback.EVENT.register(ID, Commands::RegisterWith);
    }

    public static void RegisterWith(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 env) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)class_2170.method_9247((String)"alldeathmsg").requires(s -> s.method_9259(2));
        root.then(class_2170.method_9247((String)"test").then(class_2170.method_9244((String)ENTITY_ARG, (ArgumentType)class_2186.method_9306()).executes(Commands::TestEntities)));
        root.then(class_2170.method_9247((String)"see-enabled").executes(Commands::SeeEnabled));
        root.then(class_2170.method_9247((String)"reload-styles").executes(Commands::ReloadStyles));
        root.then(class_2170.method_9247((String)"disable-all").then(class_2170.method_9244((String)CONFIRM_ARG, (ArgumentType)BoolArgumentType.bool()).executes(Commands::DisableAll)));
        root.then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)RULENAME_ARG, (ArgumentType)StringArgumentType.string()).suggests(Commands::RulenameAutofill).then(class_2170.method_9244((String)RULETYPE_ARG, (ArgumentType)StringArgumentType.string()).suggests(Commands::RuletypeAutofill).then(class_2170.method_9244((String)BOOL_ARG, (ArgumentType)BoolArgumentType.bool()).executes(Commands::SetRule)))));
        dispatcher.register(root);
    }

    private static CompletableFuture<Suggestions> RulenameAutofill(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        for (String name : DeathRules.nameToRule.keySet()) {
            builder.suggest(name);
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> RuletypeAutofill(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        builder.suggest("kill");
        builder.suggest("death");
        return builder.buildFuture();
    }

    private static int TestEntities(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection entities = class_2186.method_9317(context, (String)ENTITY_ARG);
        for (class_1297 e : entities) {
            class_5250 result = class_2561.method_43473();
            result.method_10852(DeathStyles.getStyledName(e)).method_27693(": ");
            boolean first = true;
            for (Map.Entry<String, Predicate<class_1297>> predicate : EntityPredicates.predicates.entrySet()) {
                if (!predicate.getValue().test(e)) continue;
                if (first) {
                    first = false;
                } else {
                    result.method_27693(", ");
                }
                result.method_27693(predicate.getKey());
            }
            ((class_2168)context.getSource()).method_9226(() -> result, false);
        }
        return 0;
    }

    private static int ReloadStyles(CommandContext<class_2168> context) throws CommandSyntaxException {
        DeathStyles.STYLES.clear();
        if (DeathStyles.initialize()) {
            ((class_2168)context.getSource()).method_9226(() -> AllDeathMessages.ServersideTranslatable("command.alldeathmsg.reload-styles.success", new Object[0]), true);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)AllDeathMessages.ServersideTranslatable("command.alldeathmsg.reload-styles.failure", new Object[0]));
        return -1;
    }

    private static int SeeEnabled(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1928 gamerules = source.method_9225().method_64395();
        boolean first = true;
        for (Map.Entry<String, DeathRules.MobCategory> rule : DeathRules.nameToRule.entrySet()) {
            boolean death = gamerules.method_8355(rule.getValue().death);
            boolean kill = gamerules.method_8355(rule.getValue().kill);
            if (!death && !kill) continue;
            if (first) {
                first = false;
                source.method_9226(() -> AllDeathMessages.ServersideTranslatable("command.alldeathmsg.see-enabled.success", new Object[0]), false);
            }
            class_5250 text = class_2561.method_43470((String)"- ").method_27693(rule.getKey()).method_27693(": ");
            if (death) {
                text.method_27693("Death");
            }
            if (death && kill) {
                text.method_27693(", ");
            }
            if (kill) {
                text.method_27693("Kill");
            }
            source.method_9226(() -> text, false);
        }
        if (first) {
            source.method_9226(() -> AllDeathMessages.ServersideTranslatable("command.alldeathmsg.see-enabled.failure", new Object[0]), false);
        }
        return 0;
    }

    private static int DisableAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        MinecraftServer server = world.method_8503();
        class_1928 gamerules = server.method_3767();
        if (!BoolArgumentType.getBool(context, (String)CONFIRM_ARG)) {
            ((class_2168)context.getSource()).method_9213((class_2561)AllDeathMessages.ServersideTranslatable("command.alldeathmsg.disable-all.failure", new Object[0]));
            return -1;
        }
        for (DeathRules.MobCategory rule : DeathRules.nameToRule.values()) {
            ((class_1928.class_4310)gamerules.method_20746(rule.death)).method_20758(false, server);
            ((class_1928.class_4310)gamerules.method_20746(rule.kill)).method_20758(false, server);
        }
        ((class_2168)context.getSource()).method_9226(() -> AllDeathMessages.ServersideTranslatable("command.alldeathmsg.disable-all.success", new Object[0]), true);
        return 1;
    }

    private static int SetRuleFailure(CommandContext<class_2168> context, String ruleName, String ruleType) {
        ((class_2168)context.getSource()).method_9213((class_2561)AllDeathMessages.ServersideTranslatable("command.alldeathmsg.set.failure", ruleName, ruleType));
        return -1;
    }

    private static int SetRule(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1928.class_4313<class_1928.class_4310> ruleKey;
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_1928 gamerules = server.method_3767();
        String ruleName = StringArgumentType.getString(context, (String)RULENAME_ARG);
        String ruleType = StringArgumentType.getString(context, (String)RULETYPE_ARG);
        boolean value = BoolArgumentType.getBool(context, (String)BOOL_ARG);
        DeathRules.MobCategory rules = DeathRules.nameToRule.get(StringArgumentType.getString(context, (String)RULENAME_ARG));
        if (rules == null) {
            return Commands.SetRuleFailure(context, ruleName, ruleType);
        }
        switch (ruleType) {
            case "death": {
                ruleKey = rules.death;
                break;
            }
            case "kill": {
                ruleKey = rules.kill;
                break;
            }
            default: {
                return Commands.SetRuleFailure(context, ruleName, ruleType);
            }
        }
        class_1928.class_4310 rule = (class_1928.class_4310)gamerules.method_20746(ruleKey);
        rule.method_20758(value, server);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.gamerule.set", (Object[])new Object[]{ruleKey.method_20771(), rule.toString()}), true);
        return 1;
    }
}

