/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.alldeath;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import tk.estecka.alldeath.AllDeathMessages;
import tk.estecka.alldeath.EntityPredicates;
import tk.estecka.alldeath.config.JsonConfig;
import tk.estecka.alldeath.config.RuleParser;

public class DeathRules {
    public static final String CONFIG_FILE = "alldeath-rules.json";
    public static final HashMap<String, MobCategory> nameToRule = new HashMap();
    public static final CustomGameRuleCategory DEATH_CATEGORY = new CustomGameRuleCategory(class_2960.method_60655((String)"alldeathmessages", (String)"death"), (class_2561)class_2561.method_43471((String)"gamerule.category.alldeath.death").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}));
    public static final CustomGameRuleCategory KILL_CATEGORY = new CustomGameRuleCategory(class_2960.method_60655((String)"alldeathmessages", (String)"kill"), (class_2561)class_2561.method_43471((String)"gamerule.category.alldeath.kill").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}));

    private static class_1928.class_4313<class_1928.class_4310> CreateBooleanRule(CustomGameRuleCategory category, String name, boolean defaultValue) {
        return GameRuleRegistry.register((String)("showDeathMessages." + name + "." + category.getId().method_12832()), (CustomGameRuleCategory)category, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)defaultValue));
    }

    private static void InitializeBuiltinRule(String ruleName, boolean death, boolean kill) {
        nameToRule.put(ruleName, new MobCategory(ruleName, death, kill));
    }

    public static void initialize() {
        JsonElement json;
        DeathRules.InitializeBuiltinRule("all", false, false);
        DeathRules.InitializeBuiltinRule("player", true, false);
        DeathRules.InitializeBuiltinRule("named", true, true);
        DeathRules.InitializeBuiltinRule("tamed", true, true);
        DeathRules.InitializeBuiltinRule("persistent", true, false);
        DeathRules.InitializeBuiltinRule("ephemeral", false, false);
        DeathRules.InitializeBuiltinRule("hostile", false, false);
        DeathRules.InitializeBuiltinRule("passive", false, false);
        JsonConfig configFile = new JsonConfig(CONFIG_FILE, "alldeathmessages", AllDeathMessages.LOGGER);
        try {
            json = configFile.GetOrCreateJsonFile();
        }
        catch (IOException e) {
            AllDeathMessages.LOGGER.error("Unable to load config file: {}", (Object)CONFIG_FILE);
            return;
        }
        HashMap<String, Predicate<class_1297>> config = RuleParser.CreateConfigFromJson(json);
        for (Map.Entry<String, Predicate<class_1297>> entry : config.entrySet()) {
            String ruleName = entry.getKey();
            if (EntityPredicates.predicates.containsKey(ruleName)) {
                AllDeathMessages.LOGGER.error("The rule name \"{}\" is reserved. The rule defined in the config will be ignored.", (Object)ruleName);
                continue;
            }
            EntityPredicates.put(ruleName, entry.getValue());
            nameToRule.put(ruleName, new MobCategory(ruleName, true, true));
        }
    }

    public static boolean IsRuleEnabled(MinecraftServer server, class_1928.class_4313<class_1928.class_4310> key) {
        class_1928.class_4310 rule = (class_1928.class_4310)server.method_3767().method_20746(key);
        if (rule != null) {
            return rule.method_20753();
        }
        AllDeathMessages.LOGGER.error("The rule {} doesn't exist", (Object)key.method_20771());
        return false;
    }

    @Nullable
    public static class_1928.class_4313<class_1928.class_4310> HasDeathRule(class_1309 entity) {
        for (Map.Entry<String, MobCategory> entry : nameToRule.entrySet()) {
            if (!DeathRules.IsRuleEnabled(entity.method_5682(), entry.getValue().death) || !EntityPredicates.getOrDefault(entry.getKey()).test((class_1297)entity)) continue;
            return entry.getValue().death;
        }
        return null;
    }

    @Nullable
    public static class_1928.class_4313<class_1928.class_4310> HasKillRule(class_1297 entity) {
        for (Map.Entry<String, MobCategory> entry : nameToRule.entrySet()) {
            if (!DeathRules.IsRuleEnabled(entity.method_5682(), entry.getValue().kill) || !EntityPredicates.getOrDefault(entry.getKey()).test(entity)) continue;
            return entry.getValue().kill;
        }
        return null;
    }

    public static class MobCategory {
        public final class_1928.class_4313<class_1928.class_4310> death;
        public final class_1928.class_4313<class_1928.class_4310> kill;

        public MobCategory(String name, Boolean deathDefault, Boolean killDefault) {
            this.death = DeathRules.CreateBooleanRule(DEATH_CATEGORY, name, deathDefault);
            this.kill = DeathRules.CreateBooleanRule(KILL_CATEGORY, name, killDefault);
        }
    }
}

