/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.alldeath.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashSet;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import tk.estecka.alldeath.AllDeathMessages;
import tk.estecka.alldeath.TypeEntityPredicate;

public class PredicateParser {
    public static TypeEntityPredicate CreateTypePredicateFromJson(JsonElement json, Gson gson) {
        HashSet<String> result = new HashSet<String>();
        if (!json.isJsonArray()) {
            return null;
        }
        for (JsonElement predicate : json.getAsJsonArray()) {
            if (!predicate.isJsonPrimitive() || !predicate.getAsJsonPrimitive().isString()) {
                AllDeathMessages.LOGGER.error("Invalide predicate: \"{}\"", (Object)predicate);
                continue;
            }
            String typeId = predicate.getAsString();
            if (result.contains(typeId)) {
                AllDeathMessages.LOGGER.warn("Duplicate predicate: \"{}\"", (Object)typeId);
                continue;
            }
            result.add(typeId);
            PredicateParser.SpellCheck(typeId);
        }
        return new TypeEntityPredicate(result.toArray(new String[result.size()]));
    }

    private static void SpellCheck(String typeName) {
        class_2960 id = (class_2960)class_2960.method_29186((String)typeName).getOrThrow();
        if (id.method_12836().equals("minecraft") && !class_7923.field_41177.method_10250(id)) {
            AllDeathMessages.LOGGER.warn("The type \"{}\" does not exist in vanilla minecraft", (Object)id);
        }
    }
}

