/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.alldeath.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_5251;
import org.slf4j.Logger;
import tk.estecka.alldeath.AllDeathMessages;
import tk.estecka.alldeath.DeathStyles;
import tk.estecka.alldeath.EntityPredicates;
import tk.estecka.alldeath.TypeEntityPredicate;
import tk.estecka.alldeath.config.PredicateParser;

public class StyleParser {
    private static final Gson gson = new Gson();

    public static List<DeathStyles.MobStyle> CreateConfigFromJson(JsonElement json) {
        ArrayList<DeathStyles.MobStyle> config = new ArrayList<DeathStyles.MobStyle>();
        if (!json.isJsonArray()) {
            AllDeathMessages.LOGGER.error("Style config root is not a Json Array");
            return null;
        }
        JsonArray root = json.getAsJsonArray();
        int i = 0;
        for (JsonElement elt : root) {
            DeathStyles.MobStyle style = StyleParser.CreateStyleFromJson(elt);
            if (style == null) {
                AllDeathMessages.LOGGER.error("Invalid style at index {}", (Object)i);
            } else if (style.IsEmpty()) {
                AllDeathMessages.LOGGER.warn("Style at index {} is empty and will eb ignored.", (Object)i);
            } else {
                config.add(style);
            }
            ++i;
        }
        return config;
    }

    private static DeathStyles.MobStyle CreateStyleFromJson(JsonElement json) {
        if (!json.isJsonObject()) {
            return null;
        }
        DeathStyles.MobStyle style = new DeathStyles.MobStyle();
        JsonObject jObj = json.getAsJsonObject();
        style.predicate = StyleParser.GetPredicate(jObj);
        if (style.predicate == null) {
            AllDeathMessages.LOGGER.error("Invalid predicate.");
            return null;
        }
        style.color = StyleParser.GetOptionalColor(jObj);
        style.bold = StyleParser.GetOptionalBool(jObj, "bold");
        style.italic = StyleParser.GetOptionalBool(jObj, "italic");
        style.underline = StyleParser.GetOptionalBool(jObj, "underline");
        style.strike = StyleParser.GetOptionalBool(jObj, "strikethrough");
        style.cursed = StyleParser.GetOptionalBool(jObj, "obfuscated");
        return style;
    }

    private static Predicate<class_1297> GetPredicate(JsonObject parent) {
        if (!parent.has("rule")) {
            return null;
        }
        JsonElement elt = parent.get("rule");
        if (elt.isJsonArray()) {
            TypeEntityPredicate p = PredicateParser.CreateTypePredicateFromJson(elt, gson);
            if (p == null || p.IsEmpty()) {
                return null;
            }
            return p;
        }
        if (elt.isJsonPrimitive() && elt.getAsJsonPrimitive().isString()) {
            String ruleName = elt.getAsString();
            return EntityPredicates.getOrDefault(ruleName);
        }
        return null;
    }

    private static class_5251 GetOptionalColor(JsonObject parent) {
        if (!parent.has("color")) {
            return null;
        }
        JsonElement elt = parent.get("color");
        if (elt.isJsonNull()) {
            return null;
        }
        return class_5251.field_39242.parse((DynamicOps)JsonOps.INSTANCE, (Object)elt).resultOrPartial(arg_0 -> ((Logger)AllDeathMessages.LOGGER).error(arg_0)).orElse(null);
    }

    private static Boolean GetOptionalBool(JsonObject parent, String keyName) {
        if (!parent.has(keyName) || parent.get(keyName).isJsonNull()) {
            return null;
        }
        try {
            return parent.get(keyName).getAsBoolean();
        }
        catch (Exception e) {
            AllDeathMessages.LOGGER.error("Invalid boolean in style config: {}", (Throwable)e);
            return null;
        }
    }
}

