/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.toni.wings.WingsMod;
import com.toni.wings.client.flight.FlightViews;
import com.toni.wings.client.model.ModelWingsAvian;
import com.toni.wings.client.model.ModelWingsInsectoid;
import com.toni.wings.client.renderer.PortalVertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public final class LayerWings
extends RenderLayer<PlayerRenderState, PlayerModel> {
    public static final ModelLayerLocation INSECTOID_WINGS = LayerWings.layer("insectoid_wings");
    public static final ModelLayerLocation AVIAN_WINGS = LayerWings.layer("avian_wings");

    public static void init(IEventBus modBus) {
        modBus.addListener(LayerWings::initLayers);
    }

    public LayerWings(RenderLayerParent<PlayerRenderState, PlayerModel> parent) {
        super(parent);
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull PlayerRenderState state, float limbSwing, float limbSwingAmount) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(state.id);
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        if (player.isInvisible()) {
            return;
        }
        FlightViews.get((LivingEntity)player).ifPresent(flight -> {
            flight.tick();
            flight.ifFormPresent(form -> {
                float delta = Mth.clamp((float)(state.ageInTicks - (float)player.tickCount), (float)0.0f, (float)1.0f);
                RenderType renderType = form.getRenderType();
                VertexConsumer builder = buffer.getBuffer(renderType);
                if (LayerWings.isEndPortalRenderType(renderType)) {
                    builder = new PortalVertexConsumer(builder);
                }
                poseStack.pushPose();
                if (state.isCrouching) {
                    poseStack.translate(0.0, 0.2, 0.0);
                }
                ModelPart body = ((PlayerModel)this.getParentModel()).body;
                body.translateAndRotate(poseStack);
                form.render(poseStack, builder, packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f, delta);
                poseStack.popPose();
            });
        });
    }

    public static void initLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(INSECTOID_WINGS, ModelWingsInsectoid::createBodyLayer);
        event.registerLayerDefinition(AVIAN_WINGS, ModelWingsAvian::createBodyLayer);
    }

    private static ModelLayerLocation layer(String name) {
        return LayerWings.layer(name, "main");
    }

    private static ModelLayerLocation layer(String name, String layer) {
        return new ModelLayerLocation(WingsMod.locate(name), layer);
    }

    private static boolean isEndPortalRenderType(RenderType renderType) {
        try {
            RenderType endPortal = RenderType.endPortal();
            return renderType == endPortal;
        }
        catch (Exception e) {
            return false;
        }
    }
}

