/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.flight;

import com.toni.wings.WingsAttachments;
import com.toni.wings.WingsMod;
import com.toni.wings.server.flight.Flight;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="wings")
public final class Flights {
    public static final EntityCapability<Flight, Void> FLIGHT_CAPABILITY = EntityCapability.createVoid((ResourceLocation)WingsMod.locate("flight"), Flight.class);

    private Flights() {
    }

    public static boolean has(Player player) {
        return Flights.resolve(player) != null;
    }

    public static Optional<Flight> get(Player player) {
        return Optional.ofNullable(Flights.resolve(player));
    }

    private static Flight resolve(Player player) {
        Flight flight = (Flight)player.getCapability(FLIGHT_CAPABILITY);
        if (flight == null && player.hasData((AttachmentType)WingsAttachments.FLIGHT.get())) {
            flight = (Flight)player.getData((AttachmentType)WingsAttachments.FLIGHT.get());
        }
        return flight;
    }

    public static void ifPlayer(Entity entity, BiConsumer<Player, Flight> action) {
        Flights.ifPlayer(entity, e -> true, action);
    }

    public static void ifPlayer(Entity entity, Predicate<Player> condition, BiConsumer<Player, Flight> action) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Flights.get(player).filter(flight -> condition.test(player)).ifPresent(flight -> action.accept(player, (Flight)flight));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            Flights.get(event.getOriginal()).ifPresent(oldInstance -> Flights.get(event.getEntity()).ifPresent(newInstance -> newInstance.clone((Flight)oldInstance)));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Flights.get(event.getEntity()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Flights.get(event.getEntity()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Flights.get(event.getEntity()).ifPresent(flight -> flight.sync(Flight.PlayerSet.ofSelf()));
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Flights.ifPlayer(event.getTarget(), (player, flight) -> flight.sync(Flight.PlayerSet.ofPlayer((ServerPlayer)event.getEntity())));
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(FLIGHT_CAPABILITY, EntityType.PLAYER, (player, ctx) -> (Flight)player.getData((AttachmentType)WingsAttachments.FLIGHT.get()));
    }
}

