/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.item;

import com.toni.wings.server.apparatus.FlightApparatus;
import com.toni.wings.server.effect.WingsEffects;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.flight.Flights;
import com.toni.wings.server.sound.WingsSounds;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WingsBottleItem
extends Item {
    private final FlightApparatus wings;

    public WingsBottleItem(Item.Properties properties, FlightApparatus wings) {
        super(properties);
        this.wings = wings;
    }

    public boolean isFoil(@Nonnull ItemStack stack) {
        return true;
    }

    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull LivingEntity living) {
        ItemStack result = super.finishUsingItem(stack, world, living);
        if (!world.isClientSide && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            WingsBottleItem.giveWing(player, this.wings);
            world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)WingsSounds.ITEM_ARMOR_EQUIP_WINGS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return result;
    }

    public static boolean giveWing(ServerPlayer player, FlightApparatus wings) {
        boolean changed = Flights.get((Player)player).filter(flight -> {
            if (flight.getWing() != wings) {
                flight.setWing(wings, Flight.PlayerSet.ofAll());
                return true;
            }
            return false;
        }).isPresent();
        if (WingsEffects.WINGS.isBound()) {
            player.addEffect(new MobEffectInstance(WingsEffects.WINGS, -1, 0, true, false));
        }
        return changed;
    }
}

