/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.toni.wings.server.apparatus.FlightApparatus;
import com.toni.wings.server.command.WingsArgument;
import com.toni.wings.server.item.BatBloodBottleItem;
import com.toni.wings.server.item.WingsBottleItem;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class WingsCommand {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.wings.give.failed"));
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.wings.take.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wings").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::giveWing))))).then(Commands.literal((String)"take").then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::takeSpecificWings))).executes(WingsCommand::takeWings))));
    }

    private static int giveWing(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(ctx, (String)"targets");
        FlightApparatus wings = WingsArgument.getWings(ctx, "wings");
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!WingsBottleItem.giveWing(player, wings)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.give.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.give.success.multiple", (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeWings(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(ctx, (String)"targets");
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!BatBloodBottleItem.removeWings((Player)player)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.take.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.take.success.multiple", (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeSpecificWings(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(ctx, (String)"targets");
        FlightApparatus wings = WingsArgument.getWings(ctx, "wings");
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!BatBloodBottleItem.removeWings(player, wings)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.take.success.single", (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.wings.take.success.multiple", (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }
}

