/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.client.model;

import cc.lvjia.wings.client.renderer.SodiumBypassVertexConsumer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;

public final class Model3DTexture
extends ModelPart.Cube {
    private final int width;
    private final int height;
    private final float u1;
    private final float v1;
    private final float u2;
    private final float v2;
    private static final Field POLYGONS_FIELD = Model3DTexture.findPolygonsField();

    private Model3DTexture(float posX, float posY, float posZ, int width, int height, float u1, float v1, float u2, float v2) {
        super(0, 0, posX, posY, posZ, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, EnumSet.noneOf(Direction.class));
        float f9;
        float f8;
        float f82;
        float f7;
        int k;
        Constructor<?> polygonCtor;
        Constructor<?> vertexCtor;
        this.width = width;
        this.height = height;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        int faceCount = 2 + 2 * width + 2 * height;
        Object polygonsOld = Objects.requireNonNull(Model3DTexture.getPolygons(this));
        Class<?> polygonClass = polygonsOld.getClass().getComponentType();
        Field verticesField = Model3DTexture.findArrayField(polygonClass, "vertices");
        Class<?> vertexArrayClass = verticesField.getType();
        Class<?> vertexClass = vertexArrayClass.getComponentType();
        try {
            vertexCtor = vertexClass.getDeclaredConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            vertexCtor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            polygonCtor = polygonClass.getDeclaredConstructor(vertexArrayClass, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Boolean.TYPE, Direction.class);
            polygonCtor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        Object[] polygons = (Object[])Array.newInstance(polygonClass, faceCount);
        int[] quadIndex = new int[]{0};
        float x0 = this.minX;
        float x1 = this.minX + (float)this.width;
        float y0 = this.minY;
        float y1 = this.minY + (float)this.height;
        float z0 = this.minZ;
        float z1 = this.minZ + 1.0f;
        FaceAdder faces = (fx0, fy0, fz0, fx1, fy1, fz1, fu1, fv1, fu2, fv2, normal) -> {
            Object vertices = Array.newInstance(vertexClass, 4);
            try {
                boolean v = normal.getAxis().isVertical();
                Array.set(vertices, 0, vertexCtor.newInstance(Float.valueOf(fx1), Float.valueOf(fy0), Float.valueOf(fz0), Float.valueOf(0.0f), Float.valueOf(0.0f)));
                Array.set(vertices, 1, vertexCtor.newInstance(Float.valueOf(fx0), Float.valueOf(fy0), Float.valueOf(v ? fz0 : fz1), Float.valueOf(0.0f), Float.valueOf(0.0f)));
                Array.set(vertices, 2, vertexCtor.newInstance(Float.valueOf(fx0), Float.valueOf(fy1), Float.valueOf(fz1), Float.valueOf(0.0f), Float.valueOf(0.0f)));
                Array.set(vertices, 3, vertexCtor.newInstance(Float.valueOf(fx1), Float.valueOf(fy1), Float.valueOf(v ? fz1 : fz0), Float.valueOf(0.0f), Float.valueOf(0.0f)));
                int n = quadIndex[0];
                quadIndex[0] = n + 1;
                polygons[n] = polygonCtor.newInstance(vertices, Float.valueOf(fu1), Float.valueOf(fv1), Float.valueOf(fu2), Float.valueOf(fv2), Float.valueOf(64.0f), Float.valueOf(64.0f), false, normal);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
        faces.add(x0, y0, z0, x1, y1, z0, this.u1, this.v1, this.u2, this.v2, Direction.NORTH);
        faces.add(x0, y1, z1, x1, y0, z1, this.u1, this.v2, this.u2, this.v1, Direction.SOUTH);
        float f5 = 0.5f * (this.u1 - this.u2) / (float)this.width;
        float f6 = 0.5f * (this.v1 - this.v2) / (float)this.height;
        for (k = 0; k < this.width; ++k) {
            f7 = x0 + (float)k;
            f82 = this.u1 + (this.u2 - this.u1) * ((float)k / (float)this.width) - f5;
            faces.add(f7, y0, z0, f7, y1, z1, f82, this.v1, f82, this.v2, Direction.WEST);
        }
        for (k = 0; k < this.width; ++k) {
            f8 = this.u1 + (this.u2 - this.u1) * ((float)k / (float)this.width) - f5;
            f9 = x0 + (float)(k + 1);
            faces.add(f9, y1, z0, f9, y0, z1, f8, this.v2, f8, this.v1, Direction.EAST);
        }
        for (k = 0; k < this.height; ++k) {
            f8 = this.v1 + (this.v2 - this.v1) * ((float)k / (float)this.height) - f6;
            f9 = y0 + (float)(k + 1);
            faces.add(x0, f9, z0, x1, f9, z1, this.u1, f8, this.u2, f8, Direction.UP);
        }
        for (k = 0; k < this.height; ++k) {
            f7 = y0 + (float)k;
            f82 = this.v1 + (this.v2 - this.v1) * ((float)k / (float)this.height) - f6;
            faces.add(x1, f7, z0, x0, f7, z1, this.u2, f82, this.u1, f82, Direction.DOWN);
        }
        Model3DTexture.setPolygons(this, polygons);
    }

    public void compile(@Nonnull PoseStack.Pose pose, @Nonnull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.compile(pose, SodiumBypassVertexConsumer.wrap(buffer), packedLight, packedOverlay, color);
    }

    public static ModelPart.Cube create(float posX, float posY, float posZ, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        Model3DTexture cube = new Model3DTexture(posX, posY, posZ, width, height, u, v, u + width, v + height);
        return cube;
    }

    private static Field findPolygonsField() {
        for (Field field : ModelPart.Cube.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !field.getType().isArray()) continue;
            field.setAccessible(true);
            return field;
        }
        throw new IllegalStateException("Unable to locate ModelPart.Cube polygons field");
    }

    private static Field findArrayField(Class<?> owner, String debugName) {
        for (Field field : owner.getDeclaredFields()) {
            if (!field.getType().isArray()) continue;
            field.setAccessible(true);
            return field;
        }
        throw new IllegalStateException("Unable to locate array field '" + debugName + "' on " + owner.getName());
    }

    private static Object getPolygons(ModelPart.Cube cube) {
        try {
            return POLYGONS_FIELD.get(cube);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setPolygons(ModelPart.Cube cube, Object value) {
        try {
            POLYGONS_FIELD.set(cube, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static interface FaceAdder {
        public void add(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, Direction var11);
    }
}

