/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.client.renderer;

import cc.lvjia.wings.WingsMod;
import cc.lvjia.wings.client.flight.FlightViews;
import cc.lvjia.wings.client.model.ModelWingsAvian;
import cc.lvjia.wings.client.model.ModelWingsInsectoid;
import cc.lvjia.wings.client.renderer.SodiumBypassVertexConsumer;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public final class LayerWings
extends RenderLayer<AvatarRenderState, PlayerModel> {
    public static final ModelLayerLocation INSECTOID_WINGS = LayerWings.layer("insectoid_wings");
    public static final ModelLayerLocation AVIAN_WINGS = LayerWings.layer("avian_wings");

    public static void init(IEventBus modBus) {
        modBus.addListener(LayerWings::initLayers);
    }

    public LayerWings(RenderLayerParent<AvatarRenderState, PlayerModel> parent) {
        super(parent);
    }

    public void submit(@Nonnull PoseStack poseStack, @Nonnull SubmitNodeCollector submitNodeCollector, int packedLight, @Nonnull AvatarRenderState state, float limbSwing, float limbSwingAmount) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(state.id);
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        if (player.isInvisible()) {
            return;
        }
        FlightViews.get((LivingEntity)player).ifPresent(flight -> {
            flight.tick();
            flight.ifFormPresent(form -> {
                float delta = Mth.clamp((float)(state.ageInTicks - (float)player.tickCount), (float)0.0f, (float)1.0f);
                poseStack.pushPose();
                if (state.isCrouching) {
                    poseStack.translate(0.0, 0.2, 0.0);
                }
                ModelPart body = ((PlayerModel)this.getParentModel()).body;
                body.translateAndRotate(poseStack);
                submitNodeCollector.submitCustomGeometry(poseStack, form.getRenderType(), (pose, buffer) -> {
                    PoseStack renderStack = new PoseStack();
                    PoseStack.Pose renderPose = renderStack.last();
                    renderPose.pose().set((Matrix4fc)pose.pose());
                    renderPose.normal().set((Matrix3fc)pose.normal());
                    form.render(renderStack, SodiumBypassVertexConsumer.wrap(buffer), packedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f, delta);
                });
                poseStack.popPose();
            });
        });
    }

    public static void initLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(INSECTOID_WINGS, ModelWingsInsectoid::createBodyLayer);
        event.registerLayerDefinition(AVIAN_WINGS, ModelWingsAvian::createBodyLayer);
    }

    private static ModelLayerLocation layer(String name) {
        return LayerWings.layer(name, "main");
    }

    private static ModelLayerLocation layer(String name, String layer) {
        return new ModelLayerLocation(WingsMod.locate(name), layer);
    }
}

