/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.server.apparatus;

import cc.lvjia.wings.server.apparatus.FlightApparatus;
import cc.lvjia.wings.server.flight.Flight;
import cc.lvjia.wings.server.item.WingSettings;
import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class SimpleFlightApparatus
implements FlightApparatus {
    private final WingSettings settings;

    public SimpleFlightApparatus(WingSettings settings) {
        this.settings = Objects.requireNonNull(settings);
    }

    @Override
    public void onFlight(Player player, Vec3 direction) {
        int distance = Math.round((float)direction.length() * 100.0f);
        if (distance > 0) {
            player.causeFoodExhaustion((float)distance * this.settings.getFlyingExertion());
        }
    }

    @Override
    public void onLanding(Player player, Vec3 direction) {
        player.causeFoodExhaustion(this.settings.getLandingExertion());
    }

    @Override
    public boolean isUsable(Player player) {
        return player.getFoodData().getFoodLevel() >= this.settings.getRequiredFlightSatiation();
    }

    @Override
    public boolean isLandable(Player player) {
        return player.getFoodData().getFoodLevel() >= this.settings.getRequiredLandSatiation();
    }

    @Override
    public FlightApparatus.FlightState createState(Flight flight) {
        return player -> {};
    }
}

