/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.util;

import net.minecraft.util.Mth;

public final class MathH {
    public static final float PI = (float)Math.PI;
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final float RAD_TO_DEG = 57.29578f;

    private MathH() {
    }

    public static float toRadians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float degrees) {
        return degrees * 57.29578f;
    }

    public static float lerp(float a, float b, float t) {
        return t <= 0.0f ? a : (t >= 1.0f ? b : a + (b - a) * t);
    }

    public static float lerpDegrees(float a, float b, float t) {
        return a + t * MathH.getDifference(a, b, 360.0f);
    }

    public static double lerpDegrees(double a, double b, double t) {
        return a + t * MathH.getDifference(a, b, 360.0);
    }

    private static float getDifference(float a, float b, float rot) {
        return MathH.mod(b - a + rot / 2.0f, rot) - rot / 2.0f;
    }

    private static double getDifference(double a, double b, double rot) {
        return MathH.mod(b - a + rot / 2.0, rot) - rot / 2.0;
    }

    private static float mod(float a, float b) {
        return (a % b + b) % b;
    }

    private static double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public static float easeInOut(float t) {
        return -(Mth.cos((float)((float)Math.PI * t)) - 1.0f) / 2.0f;
    }

    public static float transform(float x, float domainMin, float domainMax, float rangeMin, float rangeMax) {
        if (x <= domainMin) {
            return rangeMin;
        }
        if (x >= domainMax) {
            return rangeMax;
        }
        return (rangeMax - rangeMin) * (x - domainMin) / (domainMax - domainMin) + rangeMin;
    }
}

