/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.toni.wings.client.audio.WingsSound;
import com.toni.wings.client.flight.FlightView;
import com.toni.wings.client.flight.FlightViews;
import com.toni.wings.server.asm.AnimatePlayerModelEvent;
import com.toni.wings.server.asm.ApplyPlayerRotationsEvent;
import com.toni.wings.server.asm.EmptyOffHandPresentEvent;
import com.toni.wings.server.asm.GetCameraEyeHeightEvent;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.flight.Flights;
import com.toni.wings.util.MathH;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="wings")
public final class ClientEventHandler {
    private ClientEventHandler() {
    }

    @SubscribeEvent
    public static void onAnimatePlayerModel(AnimatePlayerModelEvent event) {
        Player player = event.getEntity();
        Flights.get(player).ifPresent(flight -> {
            float delta = event.getTicksExisted() - (float)player.f_19797_;
            float amt = flight.getFlyingAmount(delta);
            if (amt == 0.0f) {
                return;
            }
            PlayerModel<?> model = event.getModel();
            float pitch = event.getPitch();
            model.f_102808_.f_104203_ = MathH.toRadians(MathH.lerp(pitch, pitch / 4.0f - 90.0f, amt));
            model.f_102812_.f_104203_ = MathH.lerp(model.f_102812_.f_104203_, -3.2f, amt);
            model.f_102811_.f_104203_ = MathH.lerp(model.f_102811_.f_104203_, -3.2f, amt);
            model.f_102814_.f_104203_ = MathH.lerp(model.f_102814_.f_104203_, 0.0f, amt);
            model.f_102813_.f_104203_ = MathH.lerp(model.f_102813_.f_104203_, 0.0f, amt);
            model.f_102809_.m_104315_(model.f_102808_);
        });
    }

    @SubscribeEvent
    public static void onApplyRotations(ApplyPlayerRotationsEvent event) {
        Flights.ifPlayer((Entity)event.getEntity(), (player, flight) -> {
            PoseStack matrixStack = event.getMatrixStack();
            float delta = event.getDelta();
            float amt = flight.getFlyingAmount(delta);
            if (amt > 0.0f) {
                float roll = MathH.lerpDegrees(player.f_20884_ - player.f_19859_, player.f_20883_ - player.m_146908_(), delta);
                float pitch = -MathH.lerpDegrees(player.f_19860_, player.m_146909_(), delta) - 90.0f;
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(MathH.lerpDegrees(0.0f, roll, amt)));
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(MathH.lerpDegrees(0.0f, pitch, amt)));
                matrixStack.m_85837_(0.0, -1.2 * (double)MathH.easeInOut(amt), 0.0);
            }
        });
    }

    @SubscribeEvent
    public static void onGetCameraEyeHeight(GetCameraEyeHeightEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LocalPlayer) {
            FlightViews.get((LivingEntity)((LocalPlayer)entity)).ifPresent(flight -> flight.tickEyeHeight(event.getValue(), event::setValue));
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Flights.ifPlayer(event.getCamera().m_90592_(), (player, flight) -> {
            float delta = (float)event.getPartialTick();
            float amt = flight.getFlyingAmount(delta);
            if (amt > 0.0f) {
                float roll = MathH.lerpDegrees(player.f_20884_ - player.f_19859_, player.f_20883_ - player.m_146908_(), delta);
                event.setRoll(MathH.lerpDegrees(0.0f, -roll * 0.25f, amt));
            }
        });
    }

    @SubscribeEvent
    public static void onEmptyOffHandPresentEvent(EmptyOffHandPresentEvent event) {
        Flights.get((Player)event.getPlayer()).ifPresent(flight -> {
            if (flight.isFlying()) {
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Flights.ifPlayer(event.getEntity(), Player::m_7578_, (player, flight) -> Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new WingsSound((Player)player, (Flight)flight)));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player entity = event.player;
        if (event.phase == TickEvent.Phase.END && entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            FlightViews.get((LivingEntity)player).ifPresent(FlightView::tick);
        }
    }
}

