/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client;

import com.mojang.logging.LogUtils;
import com.toni.wings.WingsMod;
import com.toni.wings.client.ClientProxy;
import com.toni.wings.client.apparatus.WingForm;
import com.toni.wings.client.renderer.LayerCapeWings;
import com.toni.wings.client.renderer.LayerWings;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ReloadListener
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void m_6213_(@NotNull ResourceManager rm) {
        if (WingForm.isEmpty()) {
            WingForm.register(WingsMod.ANGEL_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.m_7981_((Object)WingsMod.ANGEL_WINGS)));
            WingForm.register(WingsMod.PARROT_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.m_7981_((Object)WingsMod.PARROT_WINGS)));
            WingForm.register(WingsMod.BAT_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.m_7981_((Object)WingsMod.BAT_WINGS)));
            WingForm.register(WingsMod.BLUE_BUTTERFLY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.m_7981_((Object)WingsMod.BLUE_BUTTERFLY_WINGS)));
            WingForm.register(WingsMod.DRAGON_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.m_7981_((Object)WingsMod.DRAGON_WINGS)));
            WingForm.register(WingsMod.EVIL_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.m_7981_((Object)WingsMod.EVIL_WINGS)));
            WingForm.register(WingsMod.FAIRY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.m_7981_((Object)WingsMod.FAIRY_WINGS)));
            WingForm.register(WingsMod.FIRE_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.m_7981_((Object)WingsMod.FIRE_WINGS)));
            WingForm.register(WingsMod.MONARCH_BUTTERFLY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.m_7981_((Object)WingsMod.MONARCH_BUTTERFLY_WINGS)));
            WingForm.register(WingsMod.SLIME_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.m_7981_((Object)WingsMod.SLIME_WINGS)));
            WingForm.register(WingsMod.LVJIA_SUPER_WINGS, ClientProxy.createEndPortalWings(WingsMod.WINGS.m_7981_((Object)WingsMod.LVJIA_SUPER_WINGS)));
        }
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher manager = mc.m_91290_();
        ((Stream)Stream.concat(manager.getSkinMap().values().stream(), manager.f_114362_.values().stream()).filter(LivingEntityRenderer.class::isInstance).map(r -> (LivingEntityRenderer)r).filter(render -> render.m_7200_() instanceof HumanoidModel).unordered()).distinct().forEach(render -> {
            if (render instanceof PlayerRenderer) {
                PlayerRenderer playerRenderer = (PlayerRenderer)render;
                this.replaceCapeLayer(playerRenderer);
            }
            ModelPart body = ((HumanoidModel)render.m_7200_()).f_102810_;
            LivingEntityRenderer livingRender = render;
            livingRender.m_115326_((RenderLayer)new LayerWings((LivingEntityRenderer<LivingEntity, HumanoidModel<LivingEntity>>)livingRender, (player, stack) -> {
                if (player.m_6047_()) {
                    stack.m_85837_(0.0, 0.2, 0.0);
                }
                body.m_104299_(stack);
            }));
        });
    }

    private void replaceCapeLayer(PlayerRenderer renderer) {
        List layers = null;
        RuntimeException failure = null;
        for (String name : new String[]{"layers", "f_115291_"}) {
            try {
                layers = (List)ObfuscationReflectionHelper.getPrivateValue(LivingEntityRenderer.class, (Object)renderer, (String)name);
                if (layers == null) continue;
                break;
            }
            catch (RuntimeException ex) {
                failure = ex;
            }
        }
        if (layers == null) {
            if (failure != null) {
                LOGGER.warn("Failed to access player renderer layers; skipping cape replacement", failure);
            }
            return;
        }
        boolean vanillaCapeRemoved = false;
        boolean hasCustomCape = false;
        Iterator iterator = layers.iterator();
        while (iterator.hasNext()) {
            Object layer = iterator.next();
            if (layer instanceof LayerCapeWings) {
                hasCustomCape = true;
                continue;
            }
            if (!(layer instanceof CapeLayer)) continue;
            iterator.remove();
            vanillaCapeRemoved = true;
        }
        if (vanillaCapeRemoved && !hasCustomCape) {
            renderer.m_115326_((RenderLayer)new LayerCapeWings((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
        }
    }
}

