/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.util;

import com.google.common.collect.ImmutableListMultimap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class KeyInputListener {
    private static final List<KeyMapping> KEY_MAPPINGS = new ArrayList<KeyMapping>();
    private final ImmutableListMultimap<KeyMapping, Runnable> bindings;

    private KeyInputListener(ImmutableListMultimap<KeyMapping, Runnable> bindings) {
        this.bindings = bindings;
    }

    @SubscribeEvent
    public void onKey(InputEvent.Key event) {
        this.bindings.asMap().entrySet().stream().filter(e -> ((KeyMapping)e.getKey()).m_90859_()).flatMap(e -> ((Collection)e.getValue()).stream()).forEach(Runnable::run);
    }

    public static Builder builder() {
        return new BuilderRoot();
    }

    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        KEY_MAPPINGS.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    public static final class BuilderRoot
    implements Builder {
        private final ImmutableListMultimap.Builder<KeyMapping, Runnable> bindings;

        private BuilderRoot() {
            this((ImmutableListMultimap.Builder<KeyMapping, Runnable>)ImmutableListMultimap.builder());
        }

        private BuilderRoot(ImmutableListMultimap.Builder<KeyMapping, Runnable> bindings) {
            this.bindings = bindings;
        }

        @Override
        public CategoryBuilder category(String category) {
            return new CategoryBuilderRoot(this, category);
        }

        @Override
        public KeyInputListener build() {
            return new KeyInputListener((ImmutableListMultimap<KeyMapping, Runnable>)this.bindings.build());
        }
    }

    public static final class BindingBuilder
    extends ChildBuilder<CategoryBuilderRoot>
    implements CategoryBuilder {
        private final KeyMapping binding;

        private BindingBuilder(CategoryBuilderRoot delegate, KeyMapping binding) {
            super(delegate);
            this.binding = binding;
        }

        public BindingBuilder onPress(Runnable runnable) {
            ((BuilderRoot)((CategoryBuilderRoot)this.parent).parent).bindings.put((Object)this.binding, (Object)runnable);
            return this;
        }

        @Override
        public BindingBuilder key(String desc, IKeyConflictContext context, KeyModifier modifier, int keyCode) {
            return ((CategoryBuilderRoot)this.parent).key(desc, context, modifier, keyCode);
        }
    }

    private static final class CategoryBuilderRoot
    extends ChildBuilder<BuilderRoot>
    implements CategoryBuilder {
        private final String category;

        private CategoryBuilderRoot(BuilderRoot delegate, String category) {
            super(delegate);
            this.category = category;
        }

        @Override
        public BindingBuilder key(String desc, IKeyConflictContext context, KeyModifier modifier, int keyCode) {
            KeyMapping binding = new KeyMapping(desc, context, modifier, InputConstants.Type.KEYSYM, keyCode, this.category);
            KEY_MAPPINGS.add(binding);
            return new BindingBuilder(this, binding);
        }
    }

    private static abstract class ChildBuilder<P extends Builder>
    implements Builder {
        final P parent;

        private ChildBuilder(P parent) {
            this.parent = parent;
        }

        @Override
        public final CategoryBuilder category(String category) {
            return this.parent.category(category);
        }

        @Override
        public final KeyInputListener build() {
            return this.parent.build();
        }
    }

    public static interface CategoryBuilder
    extends Builder {
        public BindingBuilder key(String var1, IKeyConflictContext var2, KeyModifier var3, int var4);
    }

    public static interface Builder {
        public CategoryBuilder category(String var1);

        public KeyInputListener build();
    }
}

