/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings;

import com.toni.wings.WingsMod;
import com.toni.wings.server.dreamcatcher.InSomniable;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.flight.FlightDefault;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class WingsAttachments {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"wings");
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<Flight>> FLIGHT = ATTACHMENT_TYPES.register("flight", () -> AttachmentType.builder(WingsAttachments::createFlight).serialize((IAttachmentSerializer)new FlightAttachmentSerializer()).copyOnDeath().build());
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<InSomniable>> INSOMNIABLE = ATTACHMENT_TYPES.register("insomniable", () -> AttachmentType.builder(holder -> new InSomniable()).serialize((IAttachmentSerializer)new InSomniableAttachmentSerializer()).copyOnDeath().build());

    private WingsAttachments() {
    }

    static void register(IEventBus modEventBus) {
        ATTACHMENT_TYPES.register(modEventBus);
    }

    private static Flight createFlight(IAttachmentHolder holder) {
        if (holder instanceof Player) {
            Player player = (Player)holder;
            FlightDefault flight = new FlightDefault();
            WingsMod.instance().addFlightListeners(player, flight);
            return flight;
        }
        throw new IllegalStateException("Flight attachment can only be applied to players");
    }

    private static final class InSomniableAttachmentSerializer
    implements IAttachmentSerializer<CompoundTag, InSomniable> {
        private static final InSomniable.Serializer SERIALIZER = new InSomniable.Serializer();

        private InSomniableAttachmentSerializer() {
        }

        public InSomniable read(@Nonnull IAttachmentHolder holder, @Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
            return SERIALIZER.deserialize(tag);
        }

        public CompoundTag write(@Nonnull InSomniable attachment, @Nonnull HolderLookup.Provider provider) {
            return SERIALIZER.serialize(attachment);
        }
    }

    private static final class FlightAttachmentSerializer
    implements IAttachmentSerializer<CompoundTag, Flight> {
        private static final FlightDefault.Serializer SERIALIZER = new FlightDefault.Serializer(FlightDefault::new);

        private FlightAttachmentSerializer() {
        }

        public Flight read(@Nonnull IAttachmentHolder holder, @Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
            FlightDefault flight = SERIALIZER.deserialize(tag);
            if (holder instanceof Player) {
                Player player = (Player)holder;
                WingsMod.instance().addFlightListeners(player, flight);
            }
            return flight;
        }

        public CompoundTag write(@Nonnull Flight attachment, @Nonnull HolderLookup.Provider provider) {
            if (attachment instanceof FlightDefault) {
                FlightDefault flightDefault = (FlightDefault)attachment;
                return SERIALIZER.serialize(flightDefault);
            }
            throw new IllegalStateException("Unsupported flight implementation: " + String.valueOf(attachment.getClass()));
        }
    }
}

