/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.audio;

import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.sound.WingsSounds;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;

public final class WingsSound
extends AbstractTickableSoundInstance {
    private final Player player;
    private final Flight flight;

    public WingsSound(Player player, Flight flight) {
        this(player, flight, true, 0, Math.nextAfter(0.0f, 1.0));
    }

    private WingsSound(Player player, Flight flight, boolean repeat, int repeatDelay, float volume) {
        super((SoundEvent)WingsSounds.ITEM_WINGS_FLYING.get(), SoundSource.PLAYERS, RandomSource.create());
        this.player = player;
        this.flight = flight;
        this.looping = repeat;
        this.delay = repeatDelay;
        this.volume = volume;
    }

    public void tick() {
        if (!this.player.isAlive()) {
            this.stop();
        } else if (this.flight.getFlyingAmount(1.0f) > 0.0f) {
            this.x = (float)this.player.getX();
            this.y = (float)this.player.getY();
            this.z = (float)this.player.getZ();
            float velocity = (float)this.player.getDeltaMovement().length();
            if (velocity >= 0.01f) {
                float halfVel = velocity * 0.5f;
                this.volume = Mth.clamp((float)(halfVel * halfVel), (float)0.0f, (float)1.0f);
            } else {
                this.volume = 0.0f;
            }
            float cutoff = 0.8f;
            this.pitch = this.volume > 0.8f ? 1.0f + (this.volume - 0.8f) : 1.0f;
        } else {
            this.volume = 0.0f;
        }
    }
}

