/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.dreamcatcher;

import com.toni.wings.server.item.WingsItems;
import com.toni.wings.util.NBTSerializer;
import java.util.function.IntConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class InSomniable {
    private State state;

    public InSomniable() {
        this(new SearchState());
    }

    private InSomniable(State state) {
        this.state = state;
    }

    public void onPlay(Level world, Player player, BlockPos pos, int note) {
        this.state = this.state.onPlay(world, player, pos, note);
    }

    public void clone(InSomniable other) {
        this.state = other.state.copy();
    }

    private static final class SearchState
    implements State {
        private final int[] mask = new int[]{49086, 65533, 65535, 52547, 65535, 32511, 65535, 63487, 64511};
        private final String[] members = new String[]{"wings.dreamcatcher.jiu", "wings.dreamcatcher.sua", "wings.dreamcatcher.siyeon", "wings.dreamcatcher.handong", "wings.dreamcatcher.yoohyeon", "wings.dreamcatcher.dami", "wings.dreamcatcher.gahyeon"};
        private int state;

        private SearchState() {
            this(131070);
        }

        private SearchState(int state) {
            this.state = state;
        }

        @Override
        public State onPlay(Level world, Player player, BlockPos pos, int note) {
            if (note >= 6 && note <= 14 && ((this.state = (this.state | this.mask[note - 6]) << 1) & 0x20000) == 0) {
                ItemStack stack = new ItemStack((ItemLike)WingsItems.ANGEL_WINGS_BOTTLE.get());
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)this.members[world.random.nextInt(this.members.length)]));
                ItemEntity entity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.25, (double)pos.getZ() + 0.5, stack);
                entity.setDefaultPickUpDelay();
                world.addFreshEntity((Entity)entity);
                return InSomniacState.INSTANCE;
            }
            return this;
        }

        @Override
        public State copy() {
            return new SearchState(this.state);
        }

        @Override
        public void ifSearching(IntConsumer consumer) {
            consumer.accept(this.state);
        }
    }

    private static interface State {
        public State onPlay(Level var1, Player var2, BlockPos var3, int var4);

        public State copy();

        public void ifSearching(IntConsumer var1);
    }

    public static final class Serializer
    implements NBTSerializer<InSomniable, CompoundTag> {
        private static final String SEARCH_STATE = "SearchState";

        @Override
        public CompoundTag serialize(InSomniable instance) {
            CompoundTag compound = new CompoundTag();
            instance.state.ifSearching(state -> compound.putInt(SEARCH_STATE, state));
            return compound;
        }

        @Override
        public InSomniable deserialize(CompoundTag compound) {
            State state = compound.contains(SEARCH_STATE) ? new SearchState(compound.getInt(SEARCH_STATE).orElse(131070)) : InSomniacState.INSTANCE;
            return new InSomniable(state);
        }
    }

    private static final class InSomniacState
    implements State {
        private static final State INSTANCE = new InSomniacState();

        private InSomniacState() {
        }

        @Override
        public State onPlay(Level world, Player player, BlockPos pos, int note) {
            return this;
        }

        @Override
        public State copy() {
            return this;
        }

        @Override
        public void ifSearching(IntConsumer consumer) {
        }
    }
}

