/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.flight;

import com.google.common.collect.Lists;
import com.toni.wings.WingsMod;
import com.toni.wings.server.apparatus.FlightApparatus;
import com.toni.wings.server.effect.WingsEffects;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.util.CubicBezier;
import com.toni.wings.util.MathH;
import com.toni.wings.util.NBTSerializer;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class FlightDefault
implements Flight {
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int INITIAL_TIME_FLYING = 0;
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;
    private static final ResourceLocation DEFAULT_WING_ID = WingsMod.Names.NONE;
    private final List<Flight.FlyingListener> flyingListeners = Lists.newArrayList();
    private final List<Flight.SyncListener> syncListeners = Lists.newArrayList();
    private final WingState voidState = new WingState(FlightApparatus.NONE, FlightApparatus.FlightState.NONE);
    private int prevTimeFlying = 0;
    private int timeFlying = 0;
    private boolean isFlying;
    private FlightApparatus flightApparatus = FlightApparatus.NONE;
    private WingState state = this.voidState;

    private static ResourceLocation wingIdFor(FlightApparatus wing) {
        ResourceLocation key = wing != null ? WingsMod.WINGS.getKey((Object)wing) : null;
        return key != null ? key : DEFAULT_WING_ID;
    }

    private static FlightApparatus wingFrom(ResourceLocation id) {
        return id != null ? WingsMod.WINGS.getOptional(id).orElse(FlightApparatus.NONE) : FlightApparatus.NONE;
    }

    private static FlightApparatus wingFrom(String rawId) {
        return FlightDefault.wingFrom(ResourceLocation.tryParse((String)rawId));
    }

    @Override
    public void setIsFlying(boolean isFlying, Flight.PlayerSet players) {
        if (this.isFlying != isFlying) {
            this.isFlying = isFlying;
            this.flyingListeners.forEach(Flight.FlyingListener.onChangeUsing(isFlying));
            this.sync(players);
        }
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public void setTimeFlying(int timeFlying) {
        this.timeFlying = timeFlying;
    }

    @Override
    public int getTimeFlying() {
        return this.timeFlying;
    }

    @Override
    public void setWing(FlightApparatus wing, Flight.PlayerSet players) {
        Objects.requireNonNull(wing);
        if (this.flightApparatus != wing) {
            this.flightApparatus = wing;
            this.sync(players);
        }
    }

    @Override
    public FlightApparatus getWing() {
        return this.flightApparatus;
    }

    @Override
    public float getFlyingAmount(float delta) {
        return FLY_AMOUNT_CURVE.eval(MathH.lerp(this.getPrevTimeFlying(), this.getTimeFlying(), delta) / 20.0f);
    }

    private void setPrevTimeFlying(int prevTimeFlying) {
        this.prevTimeFlying = prevTimeFlying;
    }

    private int getPrevTimeFlying() {
        return this.prevTimeFlying;
    }

    @Override
    public void registerFlyingListener(Flight.FlyingListener listener) {
        this.flyingListeners.add(listener);
    }

    @Override
    public void registerSyncListener(Flight.SyncListener listener) {
        this.syncListeners.add(listener);
    }

    @Override
    public boolean canFly(Player player) {
        return this.hasEffect(player) && this.flightApparatus.isUsable(player);
    }

    @Override
    public boolean hasEffect(Player player) {
        return WingsEffects.WINGS.isBound() && player.hasEffect(WingsEffects.WINGS);
    }

    @Override
    public boolean canLand(Player player) {
        return this.flightApparatus.isLandable(player);
    }

    private void onWornUpdate(Player player) {
        if (player.isEffectiveAi()) {
            if (this.isFlying()) {
                float speed = Mth.clampedLerp((float)0.03f, (float)0.0715f, (float)player.zza);
                float elevationBoost = MathH.transform(Math.abs(player.getXRot()), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -MathH.toRadians(player.getXRot() - 30.0f * elevationBoost);
                float yaw = -MathH.toRadians(player.getYRot()) - (float)Math.PI;
                float vxz = -Mth.cos((float)pitch);
                float vy = Mth.sin((float)pitch);
                float vz = Mth.cos((float)yaw);
                float vx = Mth.sin((float)yaw);
                player.setDeltaMovement(player.getDeltaMovement().add((double)(vx * vxz * speed), (double)(vy * speed) + (double)0.05f * (player.getXRot() > 0.0f ? (double)elevationBoost : 1.0), (double)(vz * vxz * speed)));
            }
            if (this.canLand(player)) {
                Vec3 mot = player.getDeltaMovement();
                if (mot.y() < 0.0) {
                    player.setDeltaMovement(mot.multiply(1.0, (double)0.9f, 1.0));
                }
                player.fallDistance = 0.0;
            }
        }
        if (!player.level().isClientSide) {
            if (this.flightApparatus.isUsable(player)) {
                this.state = this.state.next(this.flightApparatus);
                this.state.onUpdate(player);
            } else if (this.isFlying()) {
                this.setIsFlying(false, Flight.PlayerSet.ofAll());
                this.state = this.state.notFlying();
            }
        }
    }

    @Override
    public void tick(Player player) {
        boolean hasEffect = this.hasEffect(player);
        if (hasEffect || !player.isEffectiveAi()) {
            if (!hasEffect && !player.level().isClientSide) {
                this.setWing(FlightApparatus.NONE, Flight.PlayerSet.ofAll());
            }
            this.onWornUpdate(player);
        } else if (!player.level().isClientSide) {
            this.setWing(FlightApparatus.NONE, Flight.PlayerSet.ofAll());
            if (this.isFlying()) {
                this.setIsFlying(false, Flight.PlayerSet.ofAll());
            }
        }
        this.setPrevTimeFlying(this.getTimeFlying());
        if (this.isFlying()) {
            if (this.getTimeFlying() < 20) {
                this.setTimeFlying(this.getTimeFlying() + 1);
            } else if (player.isLocalPlayer() && player.onGround()) {
                this.setIsFlying(false, Flight.PlayerSet.ofOthers());
            }
        } else if (this.getTimeFlying() > 0) {
            this.setTimeFlying(this.getTimeFlying() - 1);
        }
    }

    @Override
    public void onFlown(Player player, Vec3 direction) {
        if (this.isFlying()) {
            this.flightApparatus.onFlight(player, direction);
        } else if (player.getDeltaMovement().y() < -0.5) {
            this.flightApparatus.onLanding(player, direction);
        }
    }

    @Override
    public void clone(Flight other) {
        this.setIsFlying(other.isFlying());
        this.setTimeFlying(other.getTimeFlying());
        this.setWing(other.getWing());
    }

    @Override
    public void sync(Flight.PlayerSet players) {
        this.syncListeners.forEach(Flight.SyncListener.onSyncUsing(players));
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isFlying());
        buf.writeVarInt(this.getTimeFlying());
        buf.writeResourceLocation(FlightDefault.wingIdFor(this.getWing()));
    }

    @Override
    public void deserialize(FriendlyByteBuf buf) {
        ResourceLocation wingId;
        this.setIsFlying(buf.readBoolean());
        this.setTimeFlying(buf.readVarInt());
        try {
            wingId = buf.readResourceLocation();
        }
        catch (IllegalArgumentException ex) {
            wingId = DEFAULT_WING_ID;
        }
        this.setWing(FlightDefault.wingFrom(wingId));
    }

    private final class WingState {
        private final FlightApparatus apparatus;
        private final FlightApparatus.FlightState activity;

        private WingState(FlightApparatus apparatus, FlightApparatus.FlightState activity) {
            this.apparatus = apparatus;
            this.activity = activity;
        }

        private WingState notFlying() {
            return FlightDefault.this.voidState;
        }

        private WingState next(FlightApparatus wf) {
            if (this.apparatus.equals(wf)) {
                return this;
            }
            return new WingState(wf, wf.createState(FlightDefault.this));
        }

        private void onUpdate(Player player) {
            this.activity.onUpdate(player);
        }
    }

    public static final class Serializer
    implements NBTSerializer<FlightDefault, CompoundTag> {
        private static final String IS_FLYING = "isFlying";
        private static final String TIME_FLYING = "timeFlying";
        private static final String WING = "wing";
        private final Supplier<FlightDefault> factory;

        public Serializer(Supplier<FlightDefault> factory) {
            this.factory = factory;
        }

        @Override
        public CompoundTag serialize(FlightDefault instance) {
            CompoundTag compound = new CompoundTag();
            compound.putBoolean(IS_FLYING, instance.isFlying());
            compound.putInt(TIME_FLYING, instance.getTimeFlying());
            compound.putString(WING, FlightDefault.wingIdFor(instance.getWing()).toString());
            return compound;
        }

        @Override
        public FlightDefault deserialize(CompoundTag compound) {
            FlightDefault f = this.factory.get();
            f.setIsFlying(compound.getBoolean(IS_FLYING).orElse(false), Flight.PlayerSet.ofAll());
            f.setTimeFlying(compound.getInt(TIME_FLYING).orElse(0));
            String wingIdRaw = compound.contains(WING) ? compound.getString(WING).orElse(DEFAULT_WING_ID.toString()) : DEFAULT_WING_ID.toString();
            f.setWing(FlightDefault.wingFrom(wingIdRaw));
            return f;
        }
    }
}

