/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.flight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.toni.wings.client.apparatus.WingForm;
import com.toni.wings.client.flight.Animator;
import com.toni.wings.client.flight.FlightView;
import com.toni.wings.client.flight.state.State;
import com.toni.wings.client.flight.state.StateIdle;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.util.function.FloatConsumer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public final class FlightViewDefault
implements FlightView {
    private static final WingState ABSENT_ANIMATOR = new WingState(){

        @Override
        public WingState nextAbsent() {
            return this;
        }

        @Override
        public WingState next(WingForm<?> form) {
            return PresentWingState.newState(form);
        }

        @Override
        public void update(Flight flight, Player player) {
        }

        @Override
        public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
        }
    };
    private final Flight flight;
    private final Player player;
    private WingState animator = ABSENT_ANIMATOR;

    public FlightViewDefault(Player player, Flight flight) {
        this.player = player;
        this.flight = flight;
    }

    @Override
    public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
        this.animator.ifFormPresent(consumer);
    }

    @Override
    public void tick() {
        this.animator = WingForm.get(this.flight.getWing()).map(view -> this.animator.next((WingForm<?>)view)).orElseGet(this.animator::nextAbsent);
        this.animator.update(this.flight, this.player);
    }

    @Override
    public void tickEyeHeight(float value, FloatConsumer valueOut) {
        if (this.flight.isFlying() || this.flight.getFlyingAmount(1.0f) > 0.0f && this.player.m_20089_() == Pose.FALL_FLYING) {
            valueOut.accept(1.0f);
        }
    }

    @Override
    public void invalidate() {
        this.animator = ABSENT_ANIMATOR;
    }

    static interface WingState {
        public WingState nextAbsent();

        public WingState next(WingForm<?> var1);

        public void update(Flight var1, Player var2);

        public void ifFormPresent(Consumer<FlightView.FormRenderer> var1);
    }

    private static final class PresentWingState
    implements WingState {
        private final WingForm<?> wing;
        private final Strategy behavior;

        private PresentWingState(WingForm<?> wing, Strategy behavior) {
            this.wing = wing;
            this.behavior = behavior;
        }

        @Override
        public WingState nextAbsent() {
            return ABSENT_ANIMATOR;
        }

        @Override
        public WingState next(WingForm<?> form) {
            if (this.wing.equals(form)) {
                return this;
            }
            return PresentWingState.newState(form);
        }

        @Override
        public void update(Flight flight, Player player) {
            this.behavior.update(flight, player);
        }

        @Override
        public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
            this.behavior.ifFormPresent(consumer);
        }

        public static <T extends Animator> WingState newState(WingForm<T> shape) {
            return new PresentWingState(shape, new WingStrategy<T>(shape));
        }

        private static class WingStrategy<T extends Animator>
        implements Strategy {
            private final WingForm<T> shape;
            private final T animator;
            private State state;

            public WingStrategy(WingForm<T> shape) {
                this.shape = shape;
                this.animator = shape.createAnimator();
                this.state = new StateIdle();
            }

            @Override
            public void update(Flight flight, Player player) {
                this.animator.update();
                State state = this.state.update(flight, player.m_20185_() - player.f_19854_, player.m_20186_() - player.f_19855_, player.m_20189_() - player.f_19856_, player);
                if (!this.state.equals(state)) {
                    state.beginAnimation((Animator)this.animator);
                }
                this.state = state;
            }

            @Override
            public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
                consumer.accept(new FlightView.FormRenderer(){

                    @Override
                    public ResourceLocation getTexture() {
                        return shape.getTexture();
                    }

                    @Override
                    public RenderType getRenderType() {
                        return shape.getRenderType();
                    }

                    @Override
                    public void render(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, float delta) {
                        shape.getModel().render(animator, delta, matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    }
                });
            }
        }
    }

    private static interface Strategy {
        public void update(Flight var1, Player var2);

        public void ifFormPresent(Consumer<FlightView.FormRenderer> var1);
    }
}

