/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.toni.wings.client.flight.AnimatorAvian;
import com.toni.wings.client.model.Model3DTexture;
import com.toni.wings.client.model.ModelWings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class ModelWingsAvian
extends ModelWings<AnimatorAvian> {
    private static final Field CUBES_FIELD = ModelWingsAvian.findCubesField();
    private ImmutableList<ModelPart> bonesLeft;
    private ImmutableList<ModelPart> bonesRight;
    private ImmutableList<ModelPart> feathersLeft;
    private ImmutableList<ModelPart> feathersRight;
    private ModelPart coracoidLeft;
    private ModelPart humerusLeft;
    private ModelPart ulnaLeft;
    private ModelPart carpalsLeft;
    private ModelPart coracoidRight;
    private ModelPart humerusRight;
    private ModelPart ulnaRight;
    private ModelPart carpalsRight;
    private ModelPart feathersCoracoidLeft;
    private ModelPart feathersPrimaryLeft;
    private ModelPart feathersSecondaryLeft;
    private ModelPart feathersTertiaryLeft;
    private ModelPart feathersCoracoidRight;
    private ModelPart feathersPrimaryRight;
    private ModelPart feathersSecondaryRight;
    private ModelPart feathersTertiaryRight;

    public ModelWingsAvian(ModelPart root) {
        this.coracoidLeft = root.m_171324_("coracoidLeft");
        this.humerusLeft = this.coracoidLeft.m_171324_("humerusLeft");
        this.ulnaLeft = this.humerusLeft.m_171324_("ulnaLeft");
        this.carpalsLeft = this.ulnaLeft.m_171324_("carpalsLeft");
        this.coracoidRight = root.m_171324_("coracoidRight");
        this.humerusRight = this.coracoidRight.m_171324_("humerusRight");
        this.ulnaRight = this.humerusRight.m_171324_("ulnaRight");
        this.carpalsRight = this.ulnaRight.m_171324_("carpalsRight");
        this.feathersCoracoidLeft = this.coracoidLeft.m_171324_("feathersCoracoidLeft");
        ModelWingsAvian.add3DTexture(this.feathersCoracoidLeft, 6, 40, 0.0f, 0.0f, -1.0f, 6, 8);
        this.feathersTertiaryLeft = this.humerusLeft.m_171324_("feathersTertiaryLeft");
        ModelWingsAvian.add3DTexture(this.feathersTertiaryLeft, 10, 14, 0.0f, 0.0f, -0.5f, 10, 14);
        this.feathersSecondaryLeft = this.ulnaLeft.m_171324_("feathersSecondaryLeft");
        ModelWingsAvian.add3DTexture(this.feathersSecondaryLeft, 31, 14, -2.0f, 0.0f, -0.5f, 11, 12);
        this.feathersPrimaryLeft = this.carpalsLeft.m_171324_("feathersPrimaryLeft");
        ModelWingsAvian.add3DTexture(this.feathersPrimaryLeft, 53, 14, 0.0f, -2.1f, -0.5f, 11, 11);
        this.feathersCoracoidRight = this.coracoidRight.m_171324_("feathersCoracoidRight");
        ModelWingsAvian.add3DTexture(this.feathersCoracoidRight, 0, 40, -6.0f, 0.0f, -1.0f, 6, 8);
        this.feathersTertiaryRight = this.humerusRight.m_171324_("feathersTertiaryRight");
        ModelWingsAvian.add3DTexture(this.feathersTertiaryRight, 0, 14, -10.0f, 0.0f, -0.5f, 10, 14);
        this.feathersSecondaryRight = this.ulnaRight.m_171324_("feathersSecondaryRight");
        ModelWingsAvian.add3DTexture(this.feathersSecondaryRight, 20, 14, -9.0f, 0.0f, -0.5f, 11, 12);
        this.feathersPrimaryRight = this.carpalsRight.m_171324_("feathersPrimaryRight");
        ModelWingsAvian.add3DTexture(this.feathersPrimaryRight, 42, 14, -11.0f, -2.1f, -0.5f, 11, 11);
        this.bonesLeft = ImmutableList.of((Object)this.coracoidLeft, (Object)this.humerusLeft, (Object)this.ulnaLeft, (Object)this.carpalsLeft);
        this.bonesRight = ImmutableList.of((Object)this.coracoidRight, (Object)this.humerusRight, (Object)this.ulnaRight, (Object)this.carpalsRight);
        this.feathersLeft = ImmutableList.of((Object)this.feathersCoracoidLeft, (Object)this.feathersTertiaryLeft, (Object)this.feathersSecondaryLeft, (Object)this.feathersPrimaryLeft);
        this.feathersRight = ImmutableList.of((Object)this.feathersCoracoidRight, (Object)this.feathersTertiaryRight, (Object)this.feathersSecondaryRight, (Object)this.feathersPrimaryRight);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition coracoidLeft = root.m_171599_("coracoidLeft", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(0.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)5.5f, (float)2.5f));
        PartDefinition coracoidRight = root.m_171599_("coracoidRight", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)5.5f, (float)2.5f));
        PartDefinition humerusLeft = coracoidLeft.m_171599_("humerusLeft", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.1f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition humerusRight = coracoidRight.m_171599_("humerusRight", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-6.9f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition ulnaLeft = humerusLeft.m_171599_("ulnaLeft", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(0.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.5f, (float)0.2f, (float)0.1f));
        PartDefinition ulnaRight = humerusRight.m_171599_("ulnaRight", CubeListBuilder.m_171558_().m_171514_(22, 6).m_171488_(-9.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.5f, (float)0.2f, (float)0.1f));
        PartDefinition carpalsLeft = ulnaLeft.m_171599_("carpalsLeft", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.5f, (float)0.0f, (float)0.0f));
        PartDefinition carpalsRight = ulnaRight.m_171599_("carpalsRight", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-8.5f, (float)0.0f, (float)0.0f));
        coracoidLeft.m_171599_("feathersCoracoidLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.4f, (float)0.0f, (float)1.0f));
        coracoidRight.m_171599_("feathersCoracoidRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.4f, (float)0.0f, (float)1.0f));
        humerusLeft.m_171599_("feathersTertiaryLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)1.0f));
        humerusRight.m_171599_("feathersTertiaryRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)1.0f));
        ulnaLeft.m_171599_("feathersSecondaryLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        ulnaRight.m_171599_("feathersSecondaryRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        carpalsLeft.m_171599_("feathersPrimaryLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        carpalsRight.m_171599_("feathersPrimaryRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void render(@Nonnull AnimatorAvian animator, float delta, @Nonnull PoseStack matrixStack, @Nonnull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ModelPart right;
        ModelPart left;
        int i;
        for (i = 0; i < this.bonesLeft.size(); ++i) {
            left = (ModelPart)this.bonesLeft.get(i);
            right = (ModelPart)this.bonesRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getWingRotation(i, delta));
        }
        for (i = 0; i < this.feathersLeft.size(); ++i) {
            left = (ModelPart)this.feathersLeft.get(i);
            right = (ModelPart)this.feathersRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getFeatherRotation(i, delta));
        }
        this.coracoidLeft.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.coracoidRight.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private static void add3DTexture(ModelPart model, int u, int v, float offX, float offY, float offZ, int width, int height) {
        ModelWingsAvian.getCubes(model).add(Model3DTexture.create(offX, offY, offZ, width, height, u, v, 64, 64));
    }

    public void m_7695_(@Nonnull PoseStack p_103111_, @Nonnull VertexConsumer p_103112_, int p_103113_, int p_103114_, float p_103115_, float p_103116_, float p_103117_, float p_103118_) {
    }

    private static Field findCubesField() {
        for (Field field : ModelPart.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !List.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            return field;
        }
        throw new IllegalStateException("Unable to locate ModelPart cubes field");
    }

    private static List<ModelPart.Cube> getCubes(ModelPart part) {
        try {
            ArrayList cubes = (ArrayList)CUBES_FIELD.get(part);
            if (cubes instanceof ImmutableList) {
                cubes = new ArrayList(cubes);
                CUBES_FIELD.set(part, cubes);
            }
            return cubes;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

