/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.toni.wings.WingsMod;
import com.toni.wings.client.flight.FlightViews;
import com.toni.wings.client.model.ModelWingsAvian;
import com.toni.wings.client.model.ModelWingsInsectoid;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public final class LayerWings
extends RenderLayer<LivingEntity, HumanoidModel<LivingEntity>> {
    private final TransformFunction transform;
    public static final ModelLayerLocation INSECTOID_WINGS = LayerWings.layer("insectoid_wings");
    public static final ModelLayerLocation AVIAN_WINGS = LayerWings.layer("avian_wings");

    public static void init(IEventBus modBus) {
        modBus.addListener(LayerWings::initLayers);
    }

    public LayerWings(LivingEntityRenderer<LivingEntity, HumanoidModel<LivingEntity>> renderer, TransformFunction transform) {
        super(renderer);
        this.transform = transform;
    }

    public void render(@Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull LivingEntity player, float limbSwing, float limbSwingAmount, float delta, float age, float headYaw, float headPitch) {
        if (!player.m_20145_()) {
            FlightViews.get(player).ifPresent(flight -> flight.ifFormPresent(form -> {
                VertexConsumer builder = buffer.m_6299_(form.getRenderType());
                matrixStack.m_85836_();
                this.transform.apply(player, matrixStack);
                form.render(matrixStack, builder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f, delta);
                matrixStack.m_85849_();
            }));
        }
    }

    public static void initLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(INSECTOID_WINGS, ModelWingsInsectoid::createBodyLayer);
        event.registerLayerDefinition(AVIAN_WINGS, ModelWingsAvian::createBodyLayer);
    }

    private static ModelLayerLocation layer(String name) {
        return LayerWings.layer(name, "main");
    }

    private static ModelLayerLocation layer(String name, String layer) {
        return new ModelLayerLocation(WingsMod.locate(name), layer);
    }

    @FunctionalInterface
    public static interface TransformFunction {
        public void apply(LivingEntity var1, PoseStack var2);
    }
}

