/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client;

import com.toni.wings.Proxy;
import com.toni.wings.WingsMod;
import com.toni.wings.client.WingsModels;
import com.toni.wings.client.apparatus.WingForm;
import com.toni.wings.client.flight.Animator;
import com.toni.wings.client.flight.AnimatorAvian;
import com.toni.wings.client.flight.AnimatorInsectoid;
import com.toni.wings.client.flight.FlightViews;
import com.toni.wings.client.model.ModelWings;
import com.toni.wings.client.model.ModelWingsAvian;
import com.toni.wings.client.model.ModelWingsInsectoid;
import com.toni.wings.client.renderer.LayerWings;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.flight.Flights;
import com.toni.wings.server.item.BatBloodBottleItem;
import com.toni.wings.server.net.serverbound.MessageControlFlying;
import com.toni.wings.util.KeyInputListener;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;

public final class ClientProxy
extends Proxy {
    private static ModelWings<AnimatorInsectoid> insectoidWings;
    private static ModelWings<AnimatorAvian> avianWings;

    @Override
    public void init(IEventBus modBus) {
        super.init(modBus);
        LayerWings.init(modBus);
        WingsModels.init(modBus);
        NeoForge.EVENT_BUS.register((Object)KeyInputListener.builder().category("key.categories.wings").key("key.wings.fly", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 82).onPress(() -> {
            LocalPlayer player = Minecraft.getInstance().player;
            Flights.get((Player)player).filter(arg_0 -> ClientProxy.lambda$init$0((Player)player, arg_0)).ifPresent(flight -> flight.toggleIsFlying(Flight.PlayerSet.ofOthers()));
            Flights.ifPlayer((Entity)player, (arg_0, arg_1) -> ClientProxy.lambda$init$2((Player)player, arg_0, arg_1));
        }).build());
        modBus.addListener(KeyInputListener::registerKeyMappings);
    }

    @Override
    public void addFlightListeners(Player player, Flight flight) {
        super.addFlightListeners(player, flight);
        if (player.isLocalPlayer()) {
            Flight.Notifier notifier = Flight.Notifier.of(() -> {}, p -> {}, () -> this.network.sendToServer(new MessageControlFlying(flight.isFlying())));
            flight.registerSyncListener(players -> players.notify(notifier));
        }
    }

    static WingForm<AnimatorAvian> createAvianWings(ResourceLocation name) {
        avianWings = new ModelWingsAvian(ClientProxy.getModel().bakeLayer(LayerWings.AVIAN_WINGS));
        return ClientProxy.createWings(name, AnimatorAvian::new, avianWings);
    }

    static WingForm<AnimatorAvian> createEndPortalWings(ResourceLocation name) {
        avianWings = new ModelWingsAvian(ClientProxy.getModel().bakeLayer(LayerWings.AVIAN_WINGS));
        return ClientProxy.createWings(name, AnimatorAvian::new, avianWings, RenderType::endPortal);
    }

    static WingForm<AnimatorInsectoid> createInsectoidWings(ResourceLocation name) {
        insectoidWings = new ModelWingsInsectoid(ClientProxy.getModel().bakeLayer(LayerWings.INSECTOID_WINGS));
        return ClientProxy.createWings(name, AnimatorInsectoid::new, insectoidWings);
    }

    private static <A extends Animator> WingForm<A> createWings(ResourceLocation name, Supplier<A> animator, ModelWings<A> model) {
        return ClientProxy.createWings(name, animator, model, null);
    }

    private static <A extends Animator> WingForm<A> createWings(ResourceLocation name, Supplier<A> animator, ModelWings<A> model, Supplier<RenderType> renderType) {
        String texturePath = String.format("textures/entity/%s.png", name.getPath());
        ResourceLocation texture = ResourceLocation.tryBuild((String)name.getNamespace(), (String)texturePath);
        if (texture == null) {
            throw new IllegalArgumentException("Invalid texture path: " + texturePath);
        }
        Supplier<RenderType> actualRenderType = renderType != null ? renderType : () -> RenderType.entityCutout((ResourceLocation)texture);
        return WingForm.of(animator, model, texture, actualRenderType);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static EntityModelSet getModel() {
        return Minecraft.getInstance().getEntityModels();
    }

    @Override
    public void invalidateFlightView(Player player) {
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            FlightViews.invalidate(clientPlayer);
        }
    }

    private static /* synthetic */ void lambda$init$2(Player player, Player p, Flight flight) {
        if (flight.getWing().equals(WingsMod.WINGLESS) && !flight.isFlying()) {
            BatBloodBottleItem.removeWings(player);
        }
    }

    private static /* synthetic */ boolean lambda$init$0(Player player, Flight flight) {
        return flight.canFly(player);
    }
}

