/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.net;

import com.toni.wings.server.net.ClientMessageContext;
import com.toni.wings.server.net.Message;
import com.toni.wings.server.net.MessageContext;
import com.toni.wings.server.net.ServerMessageContext;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class NetBuilder {
    private final NetworkRegistry.ChannelBuilder builder;
    private String version;
    private SimpleChannel channel;
    private int id;

    public NetBuilder(ResourceLocation name) {
        this.builder = NetworkRegistry.ChannelBuilder.named((ResourceLocation)name);
    }

    public NetBuilder version(int version) {
        return this.version(String.valueOf(version));
    }

    public NetBuilder version(String version) {
        if (this.version == null) {
            this.version = Objects.requireNonNull(version);
            this.builder.networkProtocolVersion(() -> version);
            return this;
        }
        throw new IllegalArgumentException("version already assigned");
    }

    public NetBuilder optionalServer() {
        this.builder.clientAcceptedVersions(this.optionalVersion());
        return this;
    }

    public NetBuilder requiredServer() {
        this.builder.clientAcceptedVersions(this.requiredVersion());
        return this;
    }

    public NetBuilder optionalClient() {
        this.builder.serverAcceptedVersions(this.optionalVersion());
        return this;
    }

    public NetBuilder requiredClient() {
        this.builder.serverAcceptedVersions(this.requiredVersion());
        return this;
    }

    private Predicate<String> optionalVersion() {
        String v = this.version;
        if (v == null) {
            throw new IllegalStateException("version not specified");
        }
        return NetworkRegistry.acceptMissingOr((String)v);
    }

    private Predicate<String> requiredVersion() {
        String v = this.version;
        if (v == null) {
            throw new IllegalStateException("version not specified");
        }
        return v::equals;
    }

    private SimpleChannel channel() {
        if (this.channel == null) {
            this.channel = this.builder.simpleChannel();
        }
        return this.channel;
    }

    public <T extends Message> MessageBuilder<T, ServerMessageContext> serverbound(Supplier<T> factory) {
        return new MessageBuilder<T, ServerMessageContext>(factory, new HandlerConsumerFactory(LogicalSide.SERVER, ServerMessageContext::new));
    }

    public <T extends Message> MessageBuilder<T, ClientMessageContext> clientbound(Supplier<T> factory) {
        return new MessageBuilder(factory, (ConsumerFactory)DistExecutor.unsafeRunForDist(() -> () -> NetBuilder.createClientConsumerFactory(), () -> () -> NetBuilder.createServerConsumerFactory()));
    }

    public SimpleChannel build() {
        return this.channel();
    }

    private static <T extends Message> ConsumerFactory<T, ClientMessageContext> createClientConsumerFactory() {
        return new HandlerConsumerFactory(LogicalSide.CLIENT, ClientMessageContext::new);
    }

    private static <T extends Message> ConsumerFactory<T, ClientMessageContext> createServerConsumerFactory() {
        return new NoopConsumerFactory();
    }

    public class MessageBuilder<T extends Message, S extends MessageContext> {
        private final Supplier<T> factory;
        private final ConsumerFactory<T, S> consumerFactory;

        protected MessageBuilder(Supplier<T> factory, ConsumerFactory<T, S> consumerFactory) {
            this.factory = factory;
            this.consumerFactory = consumerFactory;
        }

        public NetBuilder consumer(Supplier<BiConsumer<? super T, S>> consumer) {
            Supplier factory = this.factory;
            Class<?> type = ((Message)factory.get()).getClass();
            NetBuilder.this.channel().messageBuilder(type, NetBuilder.this.id++).encoder(Message::encode).decoder(buf -> {
                Message msg = (Message)factory.get();
                msg.decode((FriendlyByteBuf)buf);
                return msg;
            }).consumerNetworkThread(this.consumerFactory.create(consumer)).add();
            return NetBuilder.this;
        }
    }

    private static class HandlerConsumerFactory<T extends Message, S extends MessageContext>
    implements ConsumerFactory<T, S> {
        private final LogicalSide side;
        private final Function<NetworkEvent.Context, S> contextFactory;

        HandlerConsumerFactory(LogicalSide side, Function<NetworkEvent.Context, S> contextFactory) {
            this.side = side;
            this.contextFactory = contextFactory;
        }

        @Override
        public BiConsumer<T, Supplier<NetworkEvent.Context>> create(Supplier<BiConsumer<? super T, S>> handlerFactory) {
            BiConsumer handler = handlerFactory.get();
            return (msg, ctx) -> {
                NetworkEvent.Context c = (NetworkEvent.Context)ctx.get();
                LogicalSide receptionSide = c.getDirection().getReceptionSide();
                if (receptionSide == this.side) {
                    MessageContext s = (MessageContext)this.contextFactory.apply(c);
                    c.enqueueWork(() -> handler.accept(msg, s));
                }
                c.setPacketHandled(true);
            };
        }
    }

    static interface ConsumerFactory<T extends Message, S extends MessageContext> {
        public BiConsumer<T, Supplier<NetworkEvent.Context>> create(Supplier<BiConsumer<? super T, S>> var1);
    }

    private static class NoopConsumerFactory<T extends Message, S extends MessageContext>
    implements ConsumerFactory<T, S> {
        private NoopConsumerFactory() {
        }

        @Override
        public BiConsumer<T, Supplier<NetworkEvent.Context>> create(Supplier<BiConsumer<? super T, S>> handlerFactory) {
            return (msg, ctx) -> ((NetworkEvent.Context)ctx.get()).setPacketHandled(false);
        }
    }
}

