/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client;

import com.toni.wings.Proxy;
import com.toni.wings.WingsMod;
import com.toni.wings.client.apparatus.WingForm;
import com.toni.wings.client.flight.Animator;
import com.toni.wings.client.flight.AnimatorAvian;
import com.toni.wings.client.flight.AnimatorInsectoid;
import com.toni.wings.client.flight.FlightView;
import com.toni.wings.client.model.ModelWings;
import com.toni.wings.client.model.ModelWingsAvian;
import com.toni.wings.client.model.ModelWingsInsectoid;
import com.toni.wings.client.renderer.LayerWings;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.flight.Flights;
import com.toni.wings.server.item.BatBloodBottleItem;
import com.toni.wings.server.item.WingsItems;
import com.toni.wings.server.net.serverbound.MessageControlFlying;
import com.toni.wings.util.KeyInputListener;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public final class ClientProxy
extends Proxy {
    private static ModelWings<AnimatorInsectoid> insectoidWings;
    private static ModelWings<AnimatorAvian> avianWings;

    @Override
    public void init(IEventBus modBus) {
        super.init(modBus);
        LayerWings.init(modBus);
        MinecraftForge.EVENT_BUS.register((Object)KeyInputListener.builder().category("key.categories.wings").key("key.wings.fly", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 82).onPress(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Flights.get((Player)player).filter(arg_0 -> ClientProxy.lambda$init$0((Player)player, arg_0)).ifPresent(flight -> flight.toggleIsFlying(Flight.PlayerSet.ofOthers()));
            Flights.ifPlayer((Entity)player, (arg_0, arg_1) -> ClientProxy.lambda$init$2((Player)player, arg_0, arg_1));
        }).build());
        modBus.addListener(ClientProxy::registerItemColors);
        modBus.addListener(KeyInputListener::registerKeyMappings);
    }

    @Override
    protected void registerCapabilities(RegisterCapabilitiesEvent event) {
        super.registerCapabilities(event);
        event.register(FlightView.class);
    }

    @Override
    public void addFlightListeners(Player player, Flight flight) {
        super.addFlightListeners(player, flight);
        if (player.m_7578_()) {
            Flight.Notifier notifier = Flight.Notifier.of(() -> {}, p -> {}, () -> this.network.sendToServer(new MessageControlFlying(flight.isFlying())));
            flight.registerSyncListener(players -> players.notify(notifier));
        }
    }

    static WingForm<AnimatorAvian> createAvianWings(ResourceLocation name) {
        avianWings = new ModelWingsAvian(ClientProxy.getModel().m_171103_(LayerWings.AVIAN_WINGS));
        return ClientProxy.createWings(name, AnimatorAvian::new, avianWings);
    }

    static WingForm<AnimatorAvian> createEndPortalWings(ResourceLocation name) {
        avianWings = new ModelWingsAvian(ClientProxy.getModel().m_171103_(LayerWings.AVIAN_WINGS));
        return ClientProxy.createWings(name, AnimatorAvian::new, avianWings, RenderType::m_173239_);
    }

    static WingForm<AnimatorInsectoid> createInsectoidWings(ResourceLocation name) {
        insectoidWings = new ModelWingsInsectoid(ClientProxy.getModel().m_171103_(LayerWings.INSECTOID_WINGS));
        return ClientProxy.createWings(name, AnimatorInsectoid::new, insectoidWings);
    }

    private static <A extends Animator> WingForm<A> createWings(ResourceLocation name, Supplier<A> animator, ModelWings<A> model) {
        return ClientProxy.createWings(name, animator, model, null);
    }

    private static <A extends Animator> WingForm<A> createWings(ResourceLocation name, Supplier<A> animator, ModelWings<A> model, Supplier<RenderType> renderType) {
        String texturePath = String.format("textures/entity/%s.png", name.m_135815_());
        ResourceLocation texture = ResourceLocation.m_214293_((String)name.m_135827_(), (String)texturePath);
        if (texture == null) {
            throw new IllegalArgumentException("Invalid texture path: " + texturePath);
        }
        Supplier<RenderType> actualRenderType = renderType != null ? renderType : () -> RenderType.m_110452_((ResourceLocation)texture);
        return WingForm.of(animator, model, texture, actualRenderType);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static EntityModelSet getModel() {
        return Minecraft.m_91087_().m_167973_();
    }

    private static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex == 0 ? 10164013 : 0xFFFFFF, new ItemLike[]{(ItemLike)WingsItems.BAT_BLOOD_BOTTLE.get()});
    }

    private static /* synthetic */ void lambda$init$2(Player player, Player p, Flight flight) {
        if (flight.getWing().equals(WingsMod.WINGLESS) && !flight.isFlying()) {
            BatBloodBottleItem.removeWings(player);
        }
    }

    private static /* synthetic */ boolean lambda$init$0(Player player, Flight flight) {
        return flight.canFly(player);
    }
}

