/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.apparatus;

import com.toni.wings.server.apparatus.FlightApparatus;
import com.toni.wings.server.apparatus.SimpleFlightApparatus;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.item.WingSettings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class BuffedFlightApparatus
implements FlightApparatus {
    private final FlightApparatus delegate;
    private final List<EffectSettings> effects;
    private final MobAvoidanceSettings mobAvoidance;

    public BuffedFlightApparatus(WingSettings settings, EffectSettings ... effects) {
        this((FlightApparatus)new SimpleFlightApparatus(settings), MobAvoidanceSettings.DEFAULT, effects);
    }

    public BuffedFlightApparatus(WingSettings settings, MobAvoidanceSettings mobAvoidance, EffectSettings ... effects) {
        this((FlightApparatus)new SimpleFlightApparatus(settings), mobAvoidance, effects);
    }

    public BuffedFlightApparatus(FlightApparatus delegate, EffectSettings ... effects) {
        this(delegate, MobAvoidanceSettings.DEFAULT, effects);
    }

    public BuffedFlightApparatus(FlightApparatus delegate, MobAvoidanceSettings mobAvoidance, EffectSettings ... effects) {
        this.delegate = Objects.requireNonNull(delegate, "\u59d4\u6258");
        this.mobAvoidance = Objects.requireNonNull(mobAvoidance, "\u654c\u5bf9\u751f\u7269\u56de\u907f\u8bbe\u7f6e");
        this.effects = Arrays.stream(effects).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public void onFlight(Player player, Vec3 direction) {
        this.delegate.onFlight(player, direction);
    }

    @Override
    public void onLanding(Player player, Vec3 direction) {
        this.delegate.onLanding(player, direction);
    }

    @Override
    public boolean isUsable(Player player) {
        return this.delegate.isUsable(player);
    }

    @Override
    public boolean isLandable(Player player) {
        return this.delegate.isLandable(player);
    }

    @Override
    public FlightApparatus.FlightState createState(Flight flight) {
        final FlightApparatus.FlightState base = this.delegate.createState(flight);
        final boolean hasEffects = !this.effects.isEmpty();
        final boolean avoidanceEnabled = this.mobAvoidance.isEnabled();
        if (!hasEffects && !avoidanceEnabled) {
            return base;
        }
        return new FlightApparatus.FlightState(){
            private int mobAvoidanceCooldown;

            @Override
            public void onUpdate(Player player) {
                base.onUpdate(player);
                if (!player.f_19853_.f_46443_) {
                    if (hasEffects) {
                        BuffedFlightApparatus.this.effects.forEach(effect -> effect.apply(player));
                    }
                    if (avoidanceEnabled && --this.mobAvoidanceCooldown <= 0) {
                        this.mobAvoidanceCooldown = Math.max(1, BuffedFlightApparatus.this.mobAvoidance.intervalTicks());
                        BuffedFlightApparatus.applyHostileMobAvoidance(player, BuffedFlightApparatus.this.mobAvoidance);
                    }
                }
            }
        };
    }

    private static void applyHostileMobAvoidance(Player player, MobAvoidanceSettings settings) {
        if (player == null || !player.m_6084_()) {
            return;
        }
        double radius = settings.radius();
        if (radius <= 0.0) {
            return;
        }
        double radiusSquared = radius * radius;
        AABB searchBox = player.m_20191_().m_82400_(radius);
        List hostiles = player.f_19853_.m_6443_(Mob.class, searchBox, mob -> BuffedFlightApparatus.isRepellableHostile(mob, player, radiusSquared));
        if (hostiles.isEmpty()) {
            return;
        }
        for (Mob mob2 : hostiles) {
            BuffedFlightApparatus.neutralizeAggression(mob2, player);
            BuffedFlightApparatus.pushAwayFromPlayer(mob2, player, settings);
        }
    }

    private static boolean isRepellableHostile(Mob mob, Player player, double radiusSquared) {
        if (!(mob instanceof Enemy)) {
            return false;
        }
        if (!mob.m_6084_() || mob.m_213877_() || mob.m_5833_()) {
            return false;
        }
        if (!mob.m_21515_() || mob.m_21525_()) {
            return false;
        }
        if (mob.m_7307_((Entity)player)) {
            return false;
        }
        return !(mob.m_20280_((Entity)player) > radiusSquared);
    }

    private static void neutralizeAggression(Mob mob, Player player) {
        if (mob.m_5448_() == player) {
            mob.m_6710_(null);
        }
        if (mob.m_21188_() == player) {
            mob.m_6703_(null);
        }
        mob.m_21561_(false);
        mob.m_21573_().m_26573_();
    }

    private static void pushAwayFromPlayer(Mob mob, Player player, MobAvoidanceSettings settings) {
        Vec3 horizontal;
        double horizontalLength;
        double distance;
        double radius = settings.radius();
        if (radius <= 0.0) {
            return;
        }
        Vec3 offset = mob.m_20182_().m_82546_(player.m_20182_());
        double distanceSquared = offset.m_82556_();
        if (distanceSquared < 1.0E-6) {
            offset = new Vec3(1.0, 0.0, 0.0);
            distanceSquared = 1.0;
        }
        if ((distance = Math.sqrt(distanceSquared)) >= radius) {
            return;
        }
        double strengthFactor = 1.0 - distance / radius;
        if (strengthFactor <= 0.0) {
            return;
        }
        double pushX = 0.0;
        double pushY = 0.0;
        double pushZ = 0.0;
        if (settings.horizontalPush() > 0.0 && (horizontalLength = (horizontal = new Vec3(offset.f_82479_, 0.0, offset.f_82481_)).m_82553_()) > 1.0E-6) {
            Vec3 horizontalNormal = horizontal.m_82490_(1.0 / horizontalLength);
            double scale = settings.horizontalPush() * strengthFactor;
            pushX = horizontalNormal.f_82479_ * scale;
            pushZ = horizontalNormal.f_82481_ * scale;
        }
        if (settings.verticalPush() > 0.0) {
            pushY = settings.verticalPush() * strengthFactor;
        }
        if (pushX != 0.0 || pushY != 0.0 || pushZ != 0.0) {
            mob.m_5997_(pushX, pushY, pushZ);
        }
    }

    public record MobAvoidanceSettings(double radius, double horizontalPush, double verticalPush, int intervalTicks) {
        public static final MobAvoidanceSettings DEFAULT = new MobAvoidanceSettings(14.0, 0.35, 0.05, 10);
        public static final MobAvoidanceSettings DISABLED = new MobAvoidanceSettings(0.0, 0.0, 0.0, 0);

        public MobAvoidanceSettings {
            if (radius < 0.0) {
                throw new IllegalArgumentException("\u534a\u5f84\u5fc5\u987b\u4e3a\u975e\u8d1f\u6570");
            }
            if (horizontalPush < 0.0) {
                throw new IllegalArgumentException("\u6c34\u5e73\u63a8\u529b\u5fc5\u987b\u4e3a\u975e\u8d1f\u6570");
            }
            if (verticalPush < 0.0) {
                throw new IllegalArgumentException("\u5782\u76f4\u63a8\u529b\u5fc5\u987b\u4e3a\u975e\u8d1f\u6570");
            }
            if (intervalTicks < 0) {
                throw new IllegalArgumentException("\u95f4\u9694\u65f6\u95f4\u5fc5\u987b\u4e3a\u975e\u8d1f\u6570");
            }
        }

        public static MobAvoidanceSettings disabled() {
            return DISABLED;
        }

        public boolean isEnabled() {
            return this.radius > 0.0 && this.intervalTicks > 0 && (this.horizontalPush > 0.0 || this.verticalPush > 0.0);
        }
    }

    public record EffectSettings(MobEffect effect, int amplifier, int durationTicks, int refreshThreshold) {
        public EffectSettings {
            Objects.requireNonNull(effect, "\u6548\u679c");
            if (durationTicks <= 0) {
                throw new IllegalArgumentException("\u6301\u7eed\u65f6\u95f4\u5fc5\u987b\u4e3a\u6b63\u6570");
            }
            if (refreshThreshold < 0) {
                throw new IllegalArgumentException("\u5237\u65b0\u9608\u503c\u5fc5\u987b\u4e3a\u975e\u8d1f\u6570");
            }
        }

        public static EffectSettings of(MobEffect effect, int amplifier, int durationTicks, int refreshThreshold) {
            return new EffectSettings(effect, amplifier, durationTicks, refreshThreshold);
        }

        private void apply(Player player) {
            MobEffectInstance existing = player.m_21124_(this.effect);
            if (existing == null || existing.m_19564_() < this.amplifier || existing.m_19557_() <= this.refreshThreshold) {
                player.m_7292_(new MobEffectInstance(this.effect, this.durationTicks, this.amplifier, true, false, false));
            }
        }
    }
}

