/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client;

import com.mojang.logging.LogUtils;
import com.toni.wings.WingsMod;
import com.toni.wings.client.ClientProxy;
import com.toni.wings.client.apparatus.WingForm;
import com.toni.wings.client.renderer.LayerCapeWings;
import com.toni.wings.client.renderer.LayerWings;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.slf4j.Logger;

public class ReloadListener
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void onResourceManagerReload(@Nonnull ResourceManager rm) {
        this.reloadWingForms();
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher manager = mc.getEntityRenderDispatcher();
        Stream<PlayerRenderer> skinRenderers = manager.getSkinMap().values().stream().filter(PlayerRenderer.class::isInstance).map(PlayerRenderer.class::cast);
        Stream<PlayerRenderer> otherRenderers = this.getRendererMap(manager).values().stream().filter(PlayerRenderer.class::isInstance).map(PlayerRenderer.class::cast);
        ((Stream)Stream.concat(skinRenderers, otherRenderers).unordered()).distinct().forEach(this::augmentPlayerRenderer);
    }

    private void reloadWingForms() {
        WingForm.register(WingsMod.ANGEL_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.ANGEL_WINGS)));
        WingForm.register(WingsMod.PARROT_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.PARROT_WINGS)));
        WingForm.register(WingsMod.BAT_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.BAT_WINGS)));
        WingForm.register(WingsMod.BLUE_BUTTERFLY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.getKey((Object)WingsMod.BLUE_BUTTERFLY_WINGS)));
        WingForm.register(WingsMod.DRAGON_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.DRAGON_WINGS)));
        WingForm.register(WingsMod.EVIL_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.EVIL_WINGS)));
        WingForm.register(WingsMod.FAIRY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.getKey((Object)WingsMod.FAIRY_WINGS)));
        WingForm.register(WingsMod.FIRE_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.FIRE_WINGS)));
        WingForm.register(WingsMod.MONARCH_BUTTERFLY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.getKey((Object)WingsMod.MONARCH_BUTTERFLY_WINGS)));
        WingForm.register(WingsMod.SLIME_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.getKey((Object)WingsMod.SLIME_WINGS)));
        WingForm.register(WingsMod.LVJIA_SUPER_WINGS, ClientProxy.createEndPortalWings(WingsMod.WINGS.getKey((Object)WingsMod.LVJIA_SUPER_WINGS)));
    }

    private void augmentPlayerRenderer(PlayerRenderer renderer) {
        this.replaceCapeLayer(renderer);
        this.ensureWingsLayer(renderer);
    }

    private void ensureWingsLayer(PlayerRenderer renderer) {
        List<?> layers = this.getLayers(renderer);
        if (layers == null) {
            return;
        }
        boolean hasLayer = layers.stream().anyMatch(LayerWings.class::isInstance);
        if (!hasLayer) {
            renderer.addLayer((RenderLayer)new LayerWings((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
        }
    }

    private void replaceCapeLayer(PlayerRenderer renderer) {
        List<?> layers = this.getLayers(renderer);
        if (layers == null) {
            return;
        }
        boolean vanillaCapeRemoved = false;
        boolean hasCustomCape = false;
        Iterator<?> iterator = layers.iterator();
        while (iterator.hasNext()) {
            Object layer = iterator.next();
            if (layer instanceof LayerCapeWings) {
                hasCustomCape = true;
                continue;
            }
            if (!(layer instanceof CapeLayer)) continue;
            iterator.remove();
            vanillaCapeRemoved = true;
        }
        if (vanillaCapeRemoved && !hasCustomCape) {
            renderer.addLayer((RenderLayer)new LayerCapeWings((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
        }
    }

    private List<?> getLayers(PlayerRenderer renderer) {
        List layers = null;
        RuntimeException failure = null;
        for (String name : new String[]{"layers", "f_115291_"}) {
            try {
                layers = (List)ObfuscationReflectionHelper.getPrivateValue(LivingEntityRenderer.class, (Object)renderer, (String)name);
                if (layers == null) continue;
                break;
            }
            catch (RuntimeException ex) {
                failure = ex;
            }
        }
        if (layers == null && failure != null) {
            LOGGER.warn("Failed to access player renderer layers; skipping cape replacement", failure);
        }
        return layers;
    }

    private Map<?, ?> getRendererMap(EntityRenderDispatcher dispatcher) {
        RuntimeException failure = null;
        for (String name : new String[]{"renderers", "f_173940_"}) {
            try {
                Map map = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityRenderDispatcher.class, (Object)dispatcher, (String)name);
                if (map == null) continue;
                return map;
            }
            catch (RuntimeException ex) {
                failure = ex;
            }
        }
        if (failure != null) {
            LOGGER.warn("Failed to access entity renderer map; player layer updates may be incomplete", failure);
        }
        return Map.of();
    }
}

