/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.toni.wings.client.flight.AnimatorInsectoid;
import com.toni.wings.client.model.ModelWings;
import com.toni.wings.util.MathH;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.phys.Vec3;

public final class ModelWingsInsectoid
extends ModelWings<AnimatorInsectoid> {
    private final ModelPart wingLeft;
    private final ModelPart wingRight;

    public ModelWingsInsectoid(ModelPart root) {
        super(root);
        this.wingLeft = root.getChild("WingLeft");
        this.wingRight = root.getChild("WingRight");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("WingLeft", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -8.0f, 0.0f, 19.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)3.5f));
        partdefinition.addOrReplaceChild("WingRight", CubeListBuilder.create().texOffs(0, 24).addBox(-19.0f, -8.0f, 0.0f, 19.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)3.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void render(AnimatorInsectoid animator, float delta, PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ModelWingsInsectoid.setAngles(this.wingLeft, this.wingRight, animator.getRotation(delta));
        int color = (int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
        this.wingLeft.render(matrixStack, buffer, packedLight, packedOverlay, color);
        this.wingRight.render(matrixStack, buffer, packedLight, packedOverlay, color);
    }

    public void renderToBuffer(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    static void setAngles(ModelPart left, ModelPart right, Vec3 angles) {
        right.xRot = left.xRot = MathH.toRadians((float)angles.x);
        left.yRot = MathH.toRadians((float)angles.y);
        right.yRot = -left.yRot;
        left.zRot = MathH.toRadians((float)angles.z);
        right.zRot = -left.zRot;
    }
}

