/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.client.renderer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;

public final class PortalWingRenderType {
    public static final ResourceLocation PORTAL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/end_portal.png");
    private static final RenderType PORTAL = RenderType.endPortal();
    private static final RenderType SHADER_FALLBACK = RenderType.entityTranslucent((ResourceLocation)PORTAL_TEXTURE);
    private static final boolean IRIS_PRESENT = ModList.get().isLoaded("iris") || ModList.get().isLoaded("oculus");
    private static final String IRIS_API_CLASS = "net.irisshaders.iris.api.v0.IrisApi";
    private static Object irisApiInstance;
    private static Method irisShaderStatusMethod;

    private PortalWingRenderType() {
    }

    public static RenderType get() {
        return PortalWingRenderType.isShaderPackActive() ? SHADER_FALLBACK : PORTAL;
    }

    private static boolean isShaderPackActive() {
        if (!IRIS_PRESENT) {
            return false;
        }
        try {
            PortalWingRenderType.ensureIrisApi();
            if (irisApiInstance == null || irisShaderStatusMethod == null) {
                return false;
            }
            Object result = irisShaderStatusMethod.invoke(irisApiInstance, new Object[0]);
            return result instanceof Boolean && (Boolean)result != false;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            return false;
        }
    }

    private static void ensureIrisApi() {
        if (irisShaderStatusMethod != null && irisApiInstance != null) {
            return;
        }
        try {
            Object instance;
            Class<?> apiClass = Class.forName(IRIS_API_CLASS);
            Method getInstance = apiClass.getMethod("getInstance", new Class[0]);
            Method isShaderPackInUse = apiClass.getMethod("isShaderPackInUse", new Class[0]);
            irisApiInstance = instance = getInstance.invoke(null, new Object[0]);
            irisShaderStatusMethod = isShaderPackInUse;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            irisApiInstance = null;
            irisShaderStatusMethod = null;
        }
    }
}

