/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.asm;

import com.toni.wings.server.asm.GetCameraEyeHeightEvent;
import com.toni.wings.server.asm.GetLivingHeadLimitEvent;
import com.toni.wings.server.asm.PlayerFlightCheckEvent;
import com.toni.wings.server.asm.PlayerFlownEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public final class WingsHooks {
    private WingsHooks() {
    }

    public static boolean onFlightCheck(LivingEntity living, boolean defaultValue) {
        return living instanceof Player && WingsHooks.onFlightCheck((Player)living, defaultValue);
    }

    public static boolean onFlightCheck(Player player, boolean defaultValue) {
        if (defaultValue) {
            return true;
        }
        PlayerFlightCheckEvent ev = new PlayerFlightCheckEvent(player);
        NeoForge.EVENT_BUS.post((Event)ev);
        return ev.isFlying();
    }

    public static float onGetCameraEyeHeight(Entity entity, float eyeHeight) {
        GetCameraEyeHeightEvent ev = GetCameraEyeHeightEvent.create(entity, eyeHeight);
        NeoForge.EVENT_BUS.post((Event)ev);
        return ev.getValue();
    }

    public static boolean onUpdateBodyRotation(LivingEntity living, float movementYaw) {
        GetLivingHeadLimitEvent ev = GetLivingHeadLimitEvent.create(living);
        NeoForge.EVENT_BUS.post((Event)ev);
        if (ev.isVanilla()) {
            return false;
        }
        living.yBodyRot += Mth.wrapDegrees((float)(movementYaw - living.yBodyRot)) * 0.3f;
        float hLimit = ev.getHardLimit();
        float sLimit = ev.getSoftLimit();
        float theta = Mth.clamp((float)Mth.wrapDegrees((float)(living.getYRot() - living.yBodyRot)), (float)(-hLimit), (float)hLimit);
        living.yBodyRot = living.getYRot() - theta;
        if (theta * theta > sLimit * sLimit) {
            living.yBodyRot += theta * 0.2f;
        }
        return true;
    }

    public static void onAddFlown(Player player, double x, double y, double z) {
        NeoForge.EVENT_BUS.post((Event)new PlayerFlownEvent(player, new Vec3(x, y, z)));
    }

    public static boolean onReplaceItemSlotCheck(Item item, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (Equipable.get((ItemStack)stack) != null) {
            return true;
        }
        return item instanceof Equipable;
    }
}

