/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.asm;

import com.mojang.blaze3d.vertex.PoseStack;
import com.toni.wings.server.asm.AnimatePlayerModelEvent;
import com.toni.wings.server.asm.ApplyPlayerRotationsEvent;
import com.toni.wings.server.asm.EmptyOffHandPresentEvent;
import com.toni.wings.server.asm.GetLivingHeadLimitEvent;
import com.toni.wings.util.Access;
import java.lang.invoke.MethodHandle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public final class WingsHooksClient {
    private static int selectedItemSlot = 0;

    private WingsHooksClient() {
    }

    public static void onSetPlayerRotationAngles(AbstractClientPlayer player, PlayerModel<?> model, float ageInTicks, float headPitch) {
        NeoForge.EVENT_BUS.post((Event)new AnimatePlayerModelEvent((Player)player, model, ageInTicks, headPitch));
    }

    public static void onApplyPlayerRotations(AbstractClientPlayer player, PoseStack matrixStack, float partialTick) {
        NeoForge.EVENT_BUS.post((Event)new ApplyPlayerRotationsEvent((Player)player, matrixStack, partialTick));
    }

    public static void onTurn(Entity entity, float deltaYaw) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float theta = Mth.wrapDegrees((float)(living.getYRot() - living.yBodyRot));
            GetLivingHeadLimitEvent ev = GetLivingHeadLimitEvent.create(living);
            NeoForge.EVENT_BUS.post((Event)ev);
            float limit = ev.getHardLimit();
            if (theta < -limit || theta > limit) {
                living.yBodyRot += deltaYaw;
                living.yBodyRotO += deltaYaw;
            }
        }
    }

    public static boolean onCheckRenderEmptyHand(boolean isMainHand, ItemStack itemStackMainHand) {
        return isMainHand || !Holder.OPTIFUCK && !WingsHooksClient.isMap(itemStackMainHand);
    }

    public static boolean onCheckDoReequipAnimation(ItemStack from, ItemStack to, int slot) {
        boolean isOffHand;
        boolean fromEmpty = from.isEmpty();
        boolean toEmpty = to.isEmpty();
        boolean bl = isOffHand = slot == -1;
        if (toEmpty && isOffHand) {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player == null) {
                return true;
            }
            boolean fromMap = WingsHooksClient.isMap(GetItemStackMainHand.invoke(mc.gameRenderer.itemInHandRenderer));
            boolean toMap = WingsHooksClient.isMap(player.getMainHandItem());
            if (fromMap || toMap) {
                return fromMap != toMap;
            }
            if (fromEmpty) {
                EmptyOffHandPresentEvent ev = new EmptyOffHandPresentEvent(player);
                NeoForge.EVENT_BUS.post((Event)ev);
                return !ev.isAllowed();
            }
        }
        if (fromEmpty || toEmpty) {
            return fromEmpty != toEmpty;
        }
        boolean hasSlotChange = !isOffHand && selectedItemSlot != (selectedItemSlot = slot);
        return from.getItem().shouldCauseReequipAnimation(from, to, hasSlotChange);
    }

    private static boolean isMap(ItemStack stack) {
        return stack.getItem() instanceof MapItem;
    }

    private static final class Holder {
        private static final boolean OPTIFUCK;

        private Holder() {
        }

        static {
            boolean present;
            try {
                Class.forName("optifine.ZipResourceProvider");
                present = true;
            }
            catch (ClassNotFoundException thankGod) {
                present = false;
            }
            OPTIFUCK = present;
        }
    }

    private static final class GetItemStackMainHand {
        private static final MethodHandle MH = ((Access.GetterHandleBuilder)Access.getter(ItemInHandRenderer.class).name("f_109300_", new String[]{"mainHandItem"})).type(ItemStack.class);

        private GetItemStackMainHand() {
        }

        private static ItemStack invoke(ItemInHandRenderer instance) {
            try {
                return MH.invokeExact(instance);
            }
            catch (Throwable t) {
                throw Access.rethrow(t);
            }
        }
    }
}

