/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.item;

import com.toni.wings.WingsMod;
import com.toni.wings.server.apparatus.FlightApparatus;
import com.toni.wings.server.item.BatBloodBottleItem;
import com.toni.wings.server.item.WingsBottleItem;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class WingsItems {
    public static final DeferredRegister<Item> REG = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"wings");
    private static final FoodProperties WINGS_DRINK = new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().usingConvertsTo((ItemLike)Items.GLASS_BOTTLE).build();
    public static final DeferredHolder<Item, Item> BAT_BLOOD_BOTTLE = REG.register("bat_blood_bottle", () -> new BatBloodBottleItem(WingsItems.baseDrinkProperties().craftRemainder(Items.GLASS_BOTTLE).food(WINGS_DRINK).stacksTo(16)));
    public static final DeferredHolder<Item, Item> ANGEL_WINGS_BOTTLE = REG.register("angel_wings_bottle", WingsItems.bottle(() -> WingsMod.ANGEL_WINGS));
    public static final DeferredHolder<Item, Item> PARROT_WINGS_BOTTLE = REG.register("parrot_wings_bottle", WingsItems.bottle(() -> WingsMod.PARROT_WINGS));
    public static final DeferredHolder<Item, Item> SLIME_WINGS_BOTTLE = REG.register("slime_wings_bottle", WingsItems.bottle(() -> WingsMod.SLIME_WINGS));
    public static final DeferredHolder<Item, Item> BLUE_BUTTERFLY_WINGS_BOTTLE = REG.register("blue_butterfly_wings_bottle", WingsItems.bottle(() -> WingsMod.BLUE_BUTTERFLY_WINGS));
    public static final DeferredHolder<Item, Item> MONARCH_BUTTERFLY_WINGS_BOTTLE = REG.register("monarch_butterfly_wings_bottle", WingsItems.bottle(() -> WingsMod.MONARCH_BUTTERFLY_WINGS));
    public static final DeferredHolder<Item, Item> FIRE_WINGS_BOTTLE = REG.register("fire_wings_bottle", WingsItems.bottle(() -> WingsMod.FIRE_WINGS));
    public static final DeferredHolder<Item, Item> BAT_WINGS_BOTTLE = REG.register("bat_wings_bottle", WingsItems.bottle(() -> WingsMod.BAT_WINGS));
    public static final DeferredHolder<Item, Item> FAIRY_WINGS_BOTTLE = REG.register("fairy_wings_bottle", WingsItems.bottle(() -> WingsMod.FAIRY_WINGS));
    public static final DeferredHolder<Item, Item> EVIL_WINGS_BOTTLE = REG.register("evil_wings_bottle", WingsItems.bottle(() -> WingsMod.EVIL_WINGS));
    public static final DeferredHolder<Item, Item> DRAGON_WINGS_BOTTLE = REG.register("dragon_wings_bottle", WingsItems.bottle(() -> WingsMod.DRAGON_WINGS));
    public static final DeferredHolder<Item, Item> LVJIA_SUPER_WINGS_BOTTLE = REG.register("lvjia_super_wings_bottle", WingsItems.bottle(() -> WingsMod.LVJIA_SUPER_WINGS));

    private WingsItems() {
    }

    private static Item.Properties baseDrinkProperties() {
        return new Item.Properties();
    }

    private static Supplier<Item> bottle(Supplier<FlightApparatus> wings) {
        return () -> new WingsBottleItem(WingsItems.baseDrinkProperties().craftRemainder(Items.GLASS_BOTTLE).food(WINGS_DRINK).stacksTo(16), (FlightApparatus)wings.get());
    }

    public static void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        if (tabKey == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.accept((ItemLike)BAT_BLOOD_BOTTLE.get());
            event.accept((ItemLike)ANGEL_WINGS_BOTTLE.get());
            event.accept((ItemLike)PARROT_WINGS_BOTTLE.get());
            event.accept((ItemLike)SLIME_WINGS_BOTTLE.get());
            event.accept((ItemLike)BLUE_BUTTERFLY_WINGS_BOTTLE.get());
            event.accept((ItemLike)MONARCH_BUTTERFLY_WINGS_BOTTLE.get());
            event.accept((ItemLike)FIRE_WINGS_BOTTLE.get());
            event.accept((ItemLike)BAT_WINGS_BOTTLE.get());
            event.accept((ItemLike)FAIRY_WINGS_BOTTLE.get());
            event.accept((ItemLike)EVIL_WINGS_BOTTLE.get());
            event.accept((ItemLike)DRAGON_WINGS_BOTTLE.get());
            event.accept((ItemLike)LVJIA_SUPER_WINGS_BOTTLE.get());
        }
        if (tabKey == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)ANGEL_WINGS_BOTTLE.get());
            event.accept((ItemLike)PARROT_WINGS_BOTTLE.get());
            event.accept((ItemLike)SLIME_WINGS_BOTTLE.get());
            event.accept((ItemLike)BLUE_BUTTERFLY_WINGS_BOTTLE.get());
            event.accept((ItemLike)MONARCH_BUTTERFLY_WINGS_BOTTLE.get());
            event.accept((ItemLike)FIRE_WINGS_BOTTLE.get());
            event.accept((ItemLike)BAT_WINGS_BOTTLE.get());
            event.accept((ItemLike)FAIRY_WINGS_BOTTLE.get());
            event.accept((ItemLike)EVIL_WINGS_BOTTLE.get());
            event.accept((ItemLike)DRAGON_WINGS_BOTTLE.get());
            event.accept((ItemLike)LVJIA_SUPER_WINGS_BOTTLE.get());
        }
    }
}

