/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.potion;

import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import org.jetbrains.annotations.NotNull;

public class PotionMix
extends BrewingRecipe {
    private final Holder<Potion> from;
    private final ResourceKey<Potion> fromKey;

    public PotionMix(Holder<Potion> from, Ingredient ingredient, Holder<Potion> to) {
        this(from, ingredient, PotionMix.createPotionStack(to));
    }

    public PotionMix(Holder<Potion> from, Ingredient ingredient, ItemStack result) {
        super(Ingredient.of((ItemLike[])new ItemLike[]{Items.POTION}), ingredient, result);
        this.from = from;
        this.fromKey = from.unwrapKey().orElse(null);
    }

    public boolean isInput(@Nonnull @NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        return contents.potion().map(this::matchesFrom).orElse(false);
    }

    private boolean matchesFrom(Holder<Potion> candidate) {
        if (this.fromKey != null) {
            return candidate.is(this.fromKey);
        }
        return candidate.unwrapKey().map(arg_0 -> this.from.is(arg_0)).orElse(candidate.value() == this.from.value());
    }

    private static ItemStack createPotionStack(Holder<Potion> potion) {
        return PotionContents.createItemStack((Item)Items.POTION, potion);
    }
}

