/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings;

import com.toni.wings.server.config.WingsConfig;
import com.toni.wings.server.config.WingsItemsConfig;
import com.toni.wings.server.config.WingsOreConfig;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.flight.Flights;
import com.toni.wings.server.item.WingsItems;
import com.toni.wings.server.net.Network;
import com.toni.wings.server.net.clientbound.MessageSyncFlight;
import com.toni.wings.server.potion.PotionMix;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;

public abstract class Proxy {
    protected final Network network = new Network();

    public void init(IEventBus modBus) {
        modBus.addListener(this::setup);
        this.network.register(modBus);
        NeoForge.EVENT_BUS.addListener(this::registerBrewingRecipes);
        NeoForge.EVENT_BUS.addListener(Flights::onPlayerLoggedIn);
        NeoForge.EVENT_BUS.addListener(Flights::onPlayerStartTracking);
    }

    protected void setup(FMLCommonSetupEvent event) {
        WingsConfig.validate();
        WingsItemsConfig.validate();
        WingsOreConfig.validate();
    }

    private void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        BiConsumer<ItemLike, Supplier> reg = (item, supplier) -> {
            builder.addRecipe((IBrewingRecipe)new PotionMix((Holder<Potion>)Potions.SLOW_FALLING, Ingredient.of((ItemLike)item), new ItemStack((ItemLike)supplier.get())));
            builder.addRecipe((IBrewingRecipe)new PotionMix((Holder<Potion>)Potions.LONG_SLOW_FALLING, Ingredient.of((ItemLike)item), new ItemStack((ItemLike)supplier.get())));
        };
        reg.accept((ItemLike)Items.FEATHER, (Supplier)WingsItems.ANGEL_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.RED_DYE, (Supplier)WingsItems.PARROT_WINGS_BOTTLE);
        reg.accept((ItemLike)WingsItems.BAT_BLOOD_BOTTLE.get(), (Supplier)WingsItems.BAT_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.BLUE_DYE, (Supplier)WingsItems.BLUE_BUTTERFLY_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.LEATHER, (Supplier)WingsItems.DRAGON_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.BONE, (Supplier)WingsItems.EVIL_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.OXEYE_DAISY, (Supplier)WingsItems.FAIRY_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.BLAZE_POWDER, (Supplier)WingsItems.FIRE_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.ORANGE_DYE, (Supplier)WingsItems.MONARCH_BUTTERFLY_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.SLIME_BALL, (Supplier)WingsItems.SLIME_WINGS_BOTTLE);
    }

    public void addFlightListeners(Player player, Flight instance) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            instance.registerFlyingListener(isFlying -> {
                player.getAbilities().mayfly = isFlying;
            });
            instance.registerFlyingListener(isFlying -> {
                if (isFlying) {
                    player.removeVehicle();
                }
            });
            Flight.Notifier notifier = Flight.Notifier.of(() -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), serverPlayer), p -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (ServerPlayer)p), () -> this.sendToDimensionPlayers(serverPlayer, instance));
            instance.registerSyncListener(players -> players.notify(notifier));
            instance.sync(Flight.PlayerSet.ofOthers());
        }
    }

    public void invalidateFlightView(Player player) {
    }

    private void sendToDimensionPlayers(ServerPlayer source, Flight instance) {
        ServerLevel level = source.level();
        level.players().forEach(target -> {
            if (target != source) {
                this.network.sendToPlayer(new MessageSyncFlight((Player)source, instance), (ServerPlayer)target);
            }
        });
    }
}

