/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings;

import com.toni.wings.server.config.WingsConfig;
import com.toni.wings.server.config.WingsItemsConfig;
import com.toni.wings.server.config.WingsOreConfig;
import com.toni.wings.server.flight.Flight;
import com.toni.wings.server.item.WingsItems;
import com.toni.wings.server.net.Network;
import com.toni.wings.server.net.clientbound.MessageSyncFlight;
import com.toni.wings.server.potion.PotionMix;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.brewing.BrewingRecipeRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public abstract class Proxy {
    protected final Network network = new Network();

    public void init(IEventBus modBus) {
        modBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::registerBrewingRecipes);
    }

    protected void setup(FMLCommonSetupEvent event) {
        WingsConfig.validate();
        WingsItemsConfig.validate();
        WingsOreConfig.validate();
    }

    private void registerBrewingRecipes(BrewingRecipeRegisterEvent event) {
        BiConsumer<ItemLike, RegistryObject> reg = (item, obj) -> {
            event.addRecipe((IBrewingRecipe)new PotionMix((Holder<Potion>)Potions.SLOW_FALLING, Ingredient.of((ItemLike)item), new ItemStack((ItemLike)obj.get())));
            event.addRecipe((IBrewingRecipe)new PotionMix((Holder<Potion>)Potions.LONG_SLOW_FALLING, Ingredient.of((ItemLike)item), new ItemStack((ItemLike)obj.get())));
        };
        reg.accept((ItemLike)Items.FEATHER, WingsItems.ANGEL_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.RED_DYE, WingsItems.PARROT_WINGS_BOTTLE);
        reg.accept((ItemLike)WingsItems.BAT_BLOOD_BOTTLE.get(), WingsItems.BAT_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.BLUE_DYE, WingsItems.BLUE_BUTTERFLY_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.LEATHER, WingsItems.DRAGON_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.BONE, WingsItems.EVIL_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.OXEYE_DAISY, WingsItems.FAIRY_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.BLAZE_POWDER, WingsItems.FIRE_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.ORANGE_DYE, WingsItems.MONARCH_BUTTERFLY_WINGS_BOTTLE);
        reg.accept((ItemLike)Items.SLIME_BALL, WingsItems.SLIME_WINGS_BOTTLE);
    }

    public void addFlightListeners(Player player, Flight instance) {
        if (player instanceof ServerPlayer) {
            instance.registerFlyingListener(isFlying -> {
                player.getAbilities().mayfly = isFlying;
            });
            instance.registerFlyingListener(isFlying -> {
                if (isFlying) {
                    player.removeVehicle();
                }
            });
            Flight.Notifier notifier = Flight.Notifier.of(() -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (ServerPlayer)player), p -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (ServerPlayer)p), () -> this.network.sendToAllTracking(new MessageSyncFlight(player, instance), (Entity)player));
            instance.registerSyncListener(players -> players.notify(notifier));
        }
    }
}

