/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.config;

import com.toni.wings.server.item.ImmutableWingSettings;
import com.toni.wings.server.item.WingSettings;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigWingSettings
implements WingSettings {
    private static final Logger LOGGER = LogManager.getLogger((String)"WingsConfig");
    private static final int MIN_SATIATION = 0;
    private static final int MAX_SATIATION = 20;
    private static final double MIN_EXERTION = 0.0;
    private static final double MAX_EXERTION = 10.0;
    private final ResourceLocation key;
    private final ForgeConfigSpec.IntValue requiredFlightSatiation;
    private final ForgeConfigSpec.DoubleValue flyingExertion;
    private final ForgeConfigSpec.IntValue requiredLandSatiation;
    private final ForgeConfigSpec.DoubleValue landingExertion;
    private final int defaultFlightSatiation;
    private final double defaultFlyingExertion;
    private final int defaultLandSatiation;
    private final double defaultLandingExertion;

    ConfigWingSettings(ResourceLocation key, ForgeConfigSpec.Builder builder) {
        this(key, builder, 5, 1.0E-4, 2, 0.005);
    }

    ConfigWingSettings(ResourceLocation key, ForgeConfigSpec.Builder builder, int defaultFlightSatiation, double defaultFlyingExertion, int defaultLandSatiation, double defaultLandingExertion) {
        this.key = key;
        this.defaultFlightSatiation = defaultFlightSatiation;
        this.defaultFlyingExertion = defaultFlyingExertion;
        this.defaultLandSatiation = defaultLandSatiation;
        this.defaultLandingExertion = defaultLandingExertion;
        builder.push(key.getPath());
        this.requiredFlightSatiation = builder.comment("\u4f7f\u7528 " + String.valueOf(key) + " \u5f00\u59cb\u98de\u884c\u6240\u9700\u7684\u6700\u4f4e\u9971\u98df\u5ea6").defineInRange("requiredFlightSatiation", defaultFlightSatiation, 0, 20);
        this.flyingExertion = builder.comment("\u4f7f\u7528 " + String.valueOf(key) + " \u98de\u884c\u65f6\u6bcf\u523b\u6d88\u8017\u7684\u9971\u98df\u5ea6").defineInRange("flyingExertion", defaultFlyingExertion, 0.0, 10.0);
        this.requiredLandSatiation = builder.comment("\u4f7f\u7528 " + String.valueOf(key) + " \u5b89\u5168\u7740\u9646\u6240\u9700\u7684\u6700\u4f4e\u9971\u98df\u5ea6").defineInRange("requiredLandSatiation", defaultLandSatiation, 0, 20);
        this.landingExertion = builder.comment("\u4f7f\u7528 " + String.valueOf(key) + " \u7740\u9646\u65f6\u6d88\u8017\u7684\u9971\u98df\u5ea6").defineInRange("landingExertion", defaultLandingExertion, 0.0, 10.0);
        builder.pop();
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    public int getRequiredFlightSatiation() {
        return this.readInt(this.requiredFlightSatiation, "requiredFlightSatiation", 0, 20, this.defaultFlightSatiation);
    }

    @Override
    public float getFlyingExertion() {
        return this.readFloat(this.flyingExertion, "flyingExertion", 0.0, 10.0, this.defaultFlyingExertion);
    }

    @Override
    public int getRequiredLandSatiation() {
        return this.readInt(this.requiredLandSatiation, "requiredLandSatiation", 0, 20, this.defaultLandSatiation);
    }

    @Override
    public float getLandingExertion() {
        return this.readFloat(this.landingExertion, "landingExertion", 0.0, 10.0, this.defaultLandingExertion);
    }

    public WingSettings toImmutable() {
        return ImmutableWingSettings.of(this.getRequiredFlightSatiation(), this.getFlyingExertion(), this.getRequiredLandSatiation(), this.getLandingExertion());
    }

    public void validate() {
        this.getRequiredFlightSatiation();
        this.getFlyingExertion();
        this.getRequiredLandSatiation();
        this.getLandingExertion();
    }

    private int readInt(ForgeConfigSpec.IntValue value, String propertyName, int min, int max, int fallback) {
        int current = (Integer)value.get();
        if (current < min || current > max) {
            LOGGER.warn("\u7fc5\u8180 '{}' \u5c5e\u6027 '{}' \u8d85\u51fa\u8303\u56f4: {} (\u9884\u671f {}-{})\u3002\u6062\u590d\u4e3a\u9ed8\u8ba4\u503c {}\u3002", (Object)this.key, (Object)propertyName, (Object)current, (Object)min, (Object)max, (Object)fallback);
            value.set((Object)fallback);
            return fallback;
        }
        return current;
    }

    private float readFloat(ForgeConfigSpec.DoubleValue value, String propertyName, double min, double max, double fallback) {
        double current = (Double)value.get();
        if (Double.isNaN(current) || Double.isInfinite(current) || current < min || current > max) {
            LOGGER.warn("\u7fc5\u8180 '{}' \u5c5e\u6027 '{}' \u65e0\u6548: {} (\u9884\u671f\u5728 {} \u548c {} \u4e4b\u95f4)\u3002\u6062\u590d\u4e3a\u9ed8\u8ba4\u503c {}\u3002", (Object)this.key, (Object)propertyName, (Object)current, (Object)min, (Object)max, (Object)fallback);
            value.set((Object)fallback);
            return (float)fallback;
        }
        return (float)current;
    }
}

