/*
 * Decompiled with CFR 0.152.
 */
package com.toni.wings.server.item;

import com.toni.wings.WingsMod;
import com.toni.wings.server.apparatus.FlightApparatus;
import com.toni.wings.server.item.BatBloodBottleItem;
import com.toni.wings.server.item.WingsBottleItem;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="wings")
public final class WingsItems {
    public static final DeferredRegister<Item> REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"wings");
    public static final RegistryObject<Item> BAT_BLOOD_BOTTLE = REG.register("bat_blood_bottle", () -> new BatBloodBottleItem(WingsItems.properties("bat_blood_bottle").craftRemainder(Items.GLASS_BOTTLE).usingConvertsTo(Items.GLASS_BOTTLE).stacksTo(16)));
    public static final RegistryObject<Item> ANGEL_WINGS_BOTTLE = REG.register("angel_wings_bottle", WingsItems.bottle("angel_wings_bottle", () -> WingsMod.ANGEL_WINGS));
    public static final RegistryObject<Item> PARROT_WINGS_BOTTLE = REG.register("parrot_wings_bottle", WingsItems.bottle("parrot_wings_bottle", () -> WingsMod.PARROT_WINGS));
    public static final RegistryObject<Item> SLIME_WINGS_BOTTLE = REG.register("slime_wings_bottle", WingsItems.bottle("slime_wings_bottle", () -> WingsMod.SLIME_WINGS));
    public static final RegistryObject<Item> BLUE_BUTTERFLY_WINGS_BOTTLE = REG.register("blue_butterfly_wings_bottle", WingsItems.bottle("blue_butterfly_wings_bottle", () -> WingsMod.BLUE_BUTTERFLY_WINGS));
    public static final RegistryObject<Item> MONARCH_BUTTERFLY_WINGS_BOTTLE = REG.register("monarch_butterfly_wings_bottle", WingsItems.bottle("monarch_butterfly_wings_bottle", () -> WingsMod.MONARCH_BUTTERFLY_WINGS));
    public static final RegistryObject<Item> FIRE_WINGS_BOTTLE = REG.register("fire_wings_bottle", WingsItems.bottle("fire_wings_bottle", () -> WingsMod.FIRE_WINGS));
    public static final RegistryObject<Item> BAT_WINGS_BOTTLE = REG.register("bat_wings_bottle", WingsItems.bottle("bat_wings_bottle", () -> WingsMod.BAT_WINGS));
    public static final RegistryObject<Item> FAIRY_WINGS_BOTTLE = REG.register("fairy_wings_bottle", WingsItems.bottle("fairy_wings_bottle", () -> WingsMod.FAIRY_WINGS));
    public static final RegistryObject<Item> EVIL_WINGS_BOTTLE = REG.register("evil_wings_bottle", WingsItems.bottle("evil_wings_bottle", () -> WingsMod.EVIL_WINGS));
    public static final RegistryObject<Item> DRAGON_WINGS_BOTTLE = REG.register("dragon_wings_bottle", WingsItems.bottle("dragon_wings_bottle", () -> WingsMod.DRAGON_WINGS));
    public static final RegistryObject<Item> LVJIA_SUPER_WINGS_BOTTLE = REG.register("lvjia_super_wings_bottle", WingsItems.bottle("lvjia_super_wings_bottle", () -> WingsMod.LVJIA_SUPER_WINGS));

    private WingsItems() {
    }

    private static Item.Properties properties(String name) {
        return new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)WingsMod.locate(name))).component(DataComponents.CONSUMABLE, (Object)Consumables.DEFAULT_DRINK);
    }

    private static Supplier<Item> bottle(String name, Supplier<FlightApparatus> wings) {
        return () -> new WingsBottleItem(WingsItems.properties(name).craftRemainder(Items.GLASS_BOTTLE).usingConvertsTo(Items.GLASS_BOTTLE).stacksTo(16), (FlightApparatus)wings.get());
    }

    public static void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        if (tabKey == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.accept((ItemLike)BAT_BLOOD_BOTTLE.get());
            event.accept((ItemLike)ANGEL_WINGS_BOTTLE.get());
            event.accept((ItemLike)PARROT_WINGS_BOTTLE.get());
            event.accept((ItemLike)SLIME_WINGS_BOTTLE.get());
            event.accept((ItemLike)BLUE_BUTTERFLY_WINGS_BOTTLE.get());
            event.accept((ItemLike)MONARCH_BUTTERFLY_WINGS_BOTTLE.get());
            event.accept((ItemLike)FIRE_WINGS_BOTTLE.get());
            event.accept((ItemLike)BAT_WINGS_BOTTLE.get());
            event.accept((ItemLike)FAIRY_WINGS_BOTTLE.get());
            event.accept((ItemLike)EVIL_WINGS_BOTTLE.get());
            event.accept((ItemLike)DRAGON_WINGS_BOTTLE.get());
            event.accept((ItemLike)LVJIA_SUPER_WINGS_BOTTLE.get());
        }
        if (tabKey == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)ANGEL_WINGS_BOTTLE.get());
            event.accept((ItemLike)PARROT_WINGS_BOTTLE.get());
            event.accept((ItemLike)SLIME_WINGS_BOTTLE.get());
            event.accept((ItemLike)BLUE_BUTTERFLY_WINGS_BOTTLE.get());
            event.accept((ItemLike)MONARCH_BUTTERFLY_WINGS_BOTTLE.get());
            event.accept((ItemLike)FIRE_WINGS_BOTTLE.get());
            event.accept((ItemLike)BAT_WINGS_BOTTLE.get());
            event.accept((ItemLike)FAIRY_WINGS_BOTTLE.get());
            event.accept((ItemLike)EVIL_WINGS_BOTTLE.get());
            event.accept((ItemLike)DRAGON_WINGS_BOTTLE.get());
            event.accept((ItemLike)LVJIA_SUPER_WINGS_BOTTLE.get());
        }
    }
}

