/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.client;

import cc.lvjia.wings.client.audio.WingsSound;
import cc.lvjia.wings.client.flight.FlightView;
import cc.lvjia.wings.client.flight.FlightViews;
import cc.lvjia.wings.server.asm.AnimatePlayerModelEvent;
import cc.lvjia.wings.server.asm.ApplyPlayerRotationsEvent;
import cc.lvjia.wings.server.asm.EmptyOffHandPresentEvent;
import cc.lvjia.wings.server.asm.GetCameraEyeHeightEvent;
import cc.lvjia.wings.server.flight.Flight;
import cc.lvjia.wings.server.flight.Flights;
import cc.lvjia.wings.util.MathH;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.joml.Quaternionfc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="wings")
public final class ClientEventHandler {
    private static ResourceKey<Level> lastPlayerDimension;

    private ClientEventHandler() {
    }

    @SubscribeEvent
    public static void onAnimatePlayerModel(AnimatePlayerModelEvent event) {
        Player player = event.getEntity();
        Flights.get(player).ifPresent(flight -> {
            float delta = event.getTicksExisted() - (float)player.tickCount;
            float amt = flight.getFlyingAmount(delta);
            if (amt == 0.0f) {
                return;
            }
            PlayerModel model = event.getModel();
            float pitch = event.getPitch();
            model.head.xRot = MathH.toRadians(MathH.lerp(pitch, pitch / 4.0f - 90.0f, amt));
            model.leftArm.xRot = MathH.lerp(model.leftArm.xRot, -3.2f, amt);
            model.rightArm.xRot = MathH.lerp(model.rightArm.xRot, -3.2f, amt);
            model.leftLeg.xRot = MathH.lerp(model.leftLeg.xRot, 0.0f, amt);
            model.rightLeg.xRot = MathH.lerp(model.rightLeg.xRot, 0.0f, amt);
            model.hat.xRot = 0.0f;
            model.hat.yRot = 0.0f;
            model.hat.zRot = 0.0f;
            model.leftSleeve.xRot = 0.0f;
            model.leftSleeve.yRot = 0.0f;
            model.leftSleeve.zRot = 0.0f;
            model.rightSleeve.xRot = 0.0f;
            model.rightSleeve.yRot = 0.0f;
            model.rightSleeve.zRot = 0.0f;
            model.leftPants.xRot = 0.0f;
            model.leftPants.yRot = 0.0f;
            model.leftPants.zRot = 0.0f;
            model.rightPants.xRot = 0.0f;
            model.rightPants.yRot = 0.0f;
            model.rightPants.zRot = 0.0f;
            model.jacket.xRot = 0.0f;
            model.jacket.yRot = 0.0f;
            model.jacket.zRot = 0.0f;
        });
    }

    @SubscribeEvent
    public static void onApplyRotations(ApplyPlayerRotationsEvent event) {
        Flights.ifPlayer((Entity)event.getEntity(), (player, flight) -> {
            PoseStack matrixStack = event.getMatrixStack();
            float delta = event.getDelta();
            float amt = flight.getFlyingAmount(delta);
            if (amt > 0.0f) {
                float roll = MathH.lerpDegrees(player.yBodyRotO - player.yRotO, player.yBodyRot - player.getYRot(), delta);
                float pitch = -MathH.lerpDegrees(player.xRotO, player.getXRot(), delta) - 90.0f;
                matrixStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(MathH.lerpDegrees(0.0f, roll, amt)));
                matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(MathH.lerpDegrees(0.0f, pitch, amt)));
                matrixStack.translate(0.0, -1.2 * (double)MathH.easeInOut(amt), 0.0);
            }
        });
    }

    @SubscribeEvent
    public static void onGetCameraEyeHeight(GetCameraEyeHeightEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LocalPlayer) {
            FlightViews.get((LivingEntity)((LocalPlayer)entity)).ifPresent(flight -> flight.tickEyeHeight(event.getValue(), event::setValue));
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Flights.ifPlayer(event.getCamera().getEntity(), (player, flight) -> {
            float delta = (float)event.getPartialTick();
            float amt = flight.getFlyingAmount(delta);
            if (amt > 0.0f) {
                float roll = MathH.lerpDegrees(player.yBodyRotO - player.yRotO, player.yBodyRot - player.getYRot(), delta);
                float targetRoll = MathH.lerpDegrees(0.0f, -roll * 0.25f, amt);
                targetRoll = !Float.isFinite(targetRoll) || Math.abs(targetRoll) > 75.0f ? 0.0f : Mth.clamp((float)targetRoll, (float)-60.0f, (float)60.0f);
                event.setRoll(targetRoll);
            }
        });
    }

    @SubscribeEvent
    public static void onEmptyOffHandPresentEvent(EmptyOffHandPresentEvent event) {
        Flights.get((Player)event.getPlayer()).ifPresent(flight -> {
            if (flight.isFlying()) {
                event.allow();
            }
        });
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Flights.ifPlayer(event.getEntity(), Player::isLocalPlayer, (player, flight) -> Minecraft.getInstance().getSoundManager().play((SoundInstance)new WingsSound((Player)player, (Flight)flight)));
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player entity = event.getEntity();
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            FlightViews.get((LivingEntity)player).ifPresent(FlightView::tick);
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            lastPlayerDimension = null;
            return;
        }
        ResourceKey current = player.level().dimension();
        if (current != lastPlayerDimension) {
            lastPlayerDimension = current;
            FlightViews.invalidate((AbstractClientPlayer)player);
        }
    }
}

