/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.client;

import cc.lvjia.wings.WingsMod;
import cc.lvjia.wings.client.ClientProxy;
import cc.lvjia.wings.client.apparatus.WingForm;
import cc.lvjia.wings.client.renderer.LayerCapeWings;
import cc.lvjia.wings.client.renderer.LayerWings;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.slf4j.Logger;

public class ReloadListener
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void onResourceManagerReload(@Nonnull ResourceManager rm) {
        if (WingForm.isEmpty()) {
            WingForm.register(WingsMod.ANGEL_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.ANGEL_WINGS)));
            WingForm.register(WingsMod.PARROT_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.PARROT_WINGS)));
            WingForm.register(WingsMod.BAT_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.BAT_WINGS)));
            WingForm.register(WingsMod.BLUE_BUTTERFLY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.getKey((Object)WingsMod.BLUE_BUTTERFLY_WINGS)));
            WingForm.register(WingsMod.DRAGON_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.DRAGON_WINGS)));
            WingForm.register(WingsMod.EVIL_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.EVIL_WINGS)));
            WingForm.register(WingsMod.FAIRY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.getKey((Object)WingsMod.FAIRY_WINGS)));
            WingForm.register(WingsMod.FIRE_WINGS, ClientProxy.createAvianWings(WingsMod.WINGS.getKey((Object)WingsMod.FIRE_WINGS)));
            WingForm.register(WingsMod.MONARCH_BUTTERFLY_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.getKey((Object)WingsMod.MONARCH_BUTTERFLY_WINGS)));
            WingForm.register(WingsMod.SLIME_WINGS, ClientProxy.createInsectoidWings(WingsMod.WINGS.getKey((Object)WingsMod.SLIME_WINGS)));
            WingForm.register(WingsMod.LVJIA_SUPER_WINGS, ClientProxy.createEndPortalWings(WingsMod.WINGS.getKey((Object)WingsMod.LVJIA_SUPER_WINGS)));
        }
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher manager = mc.getEntityRenderDispatcher();
        Stream<AvatarRenderer> playerRenderers = manager.getPlayerRenderers().values().stream().filter(AvatarRenderer.class::isInstance).map(AvatarRenderer.class::cast);
        Stream<AvatarRenderer> mannequinRenderers = manager.getMannequinRenderers().values().stream().filter(AvatarRenderer.class::isInstance).map(AvatarRenderer.class::cast);
        Stream<AvatarRenderer> otherRenderers = this.getRendererMap(manager).values().stream().filter(AvatarRenderer.class::isInstance).map(AvatarRenderer.class::cast);
        ((Stream)Stream.concat(Stream.concat(playerRenderers, mannequinRenderers), otherRenderers).unordered()).distinct().forEach(this::augmentPlayerRenderer);
    }

    private void augmentPlayerRenderer(AvatarRenderer<?> renderer) {
        this.replaceCapeLayer(renderer);
        this.ensureWingsLayer(renderer);
    }

    private void ensureWingsLayer(AvatarRenderer<?> renderer) {
        List<?> layers = this.getLayers(renderer);
        if (layers == null) {
            return;
        }
        boolean hasLayer = layers.stream().anyMatch(LayerWings.class::isInstance);
        if (!hasLayer) {
            renderer.addLayer((RenderLayer)new LayerWings((RenderLayerParent<AvatarRenderState, PlayerModel>)renderer));
        }
    }

    private void replaceCapeLayer(AvatarRenderer<?> renderer) {
        List<?> layers = this.getLayers(renderer);
        if (layers == null) {
            return;
        }
        boolean vanillaCapeRemoved = false;
        boolean hasCustomCape = false;
        Iterator<?> iterator = layers.iterator();
        while (iterator.hasNext()) {
            Object layer = iterator.next();
            if (layer instanceof LayerCapeWings) {
                hasCustomCape = true;
                continue;
            }
            if (!(layer instanceof CapeLayer)) continue;
            iterator.remove();
            vanillaCapeRemoved = true;
        }
        if (vanillaCapeRemoved && !hasCustomCape) {
            renderer.addLayer((RenderLayer)new LayerCapeWings((RenderLayerParent<AvatarRenderState, PlayerModel>)renderer, Minecraft.getInstance().getEntityModels()));
        }
    }

    private List<?> getLayers(AvatarRenderer<?> renderer) {
        List layers = null;
        RuntimeException failure = null;
        for (String name : new String[]{"layers", "f_115291_"}) {
            try {
                layers = (List)ObfuscationReflectionHelper.getPrivateValue(LivingEntityRenderer.class, renderer, (String)name);
                if (layers == null) continue;
                break;
            }
            catch (RuntimeException ex) {
                failure = ex;
            }
        }
        if (layers == null && failure != null) {
            LOGGER.warn("Failed to access player renderer layers; skipping cape replacement", failure);
        }
        return layers;
    }

    private Map<?, ?> getRendererMap(EntityRenderDispatcher dispatcher) {
        RuntimeException failure = null;
        for (String name : new String[]{"renderers", "f_173940_"}) {
            try {
                Map map = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityRenderDispatcher.class, (Object)dispatcher, (String)name);
                if (map == null) continue;
                return map;
            }
            catch (RuntimeException ex) {
                failure = ex;
            }
        }
        if (failure != null) {
            LOGGER.warn("Failed to access entity renderer map; player layer updates may be incomplete", failure);
        }
        return Map.of();
    }
}

