/*
 * Decompiled with CFR 0.152.
 */
package cc.lvjia.wings.client.model;

import cc.lvjia.wings.client.flight.AnimatorAvian;
import cc.lvjia.wings.client.model.Model3DTexture;
import cc.lvjia.wings.client.model.ModelWings;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.ARGB;

public final class ModelWingsAvian
extends ModelWings<AnimatorAvian> {
    private static final Field CUBES_FIELD = ModelWingsAvian.findCubesField();
    private final ImmutableList<ModelPart> bonesLeft;
    private final ImmutableList<ModelPart> bonesRight;
    private final ImmutableList<ModelPart> feathersLeft;
    private final ImmutableList<ModelPart> feathersRight;
    private final ModelPart coracoidLeft;
    private final ModelPart humerusLeft;
    private final ModelPart ulnaLeft;
    private final ModelPart carpalsLeft;
    private final ModelPart coracoidRight;
    private final ModelPart humerusRight;
    private final ModelPart ulnaRight;
    private final ModelPart carpalsRight;
    private final ModelPart feathersCoracoidLeft;
    private final ModelPart feathersPrimaryLeft;
    private final ModelPart feathersSecondaryLeft;
    private final ModelPart feathersTertiaryLeft;
    private final ModelPart feathersCoracoidRight;
    private final ModelPart feathersPrimaryRight;
    private final ModelPart feathersSecondaryRight;
    private final ModelPart feathersTertiaryRight;

    public ModelWingsAvian(ModelPart root) {
        super(root);
        this.coracoidLeft = root.getChild("coracoidLeft");
        this.humerusLeft = this.coracoidLeft.getChild("humerusLeft");
        this.ulnaLeft = this.humerusLeft.getChild("ulnaLeft");
        this.carpalsLeft = this.ulnaLeft.getChild("carpalsLeft");
        this.coracoidRight = root.getChild("coracoidRight");
        this.humerusRight = this.coracoidRight.getChild("humerusRight");
        this.ulnaRight = this.humerusRight.getChild("ulnaRight");
        this.carpalsRight = this.ulnaRight.getChild("carpalsRight");
        this.feathersCoracoidLeft = this.coracoidLeft.getChild("feathersCoracoidLeft");
        ModelWingsAvian.add3DTexture(this.feathersCoracoidLeft, 6, 40, 0.0f, 0.0f, -1.0f, 6, 8);
        this.feathersTertiaryLeft = this.humerusLeft.getChild("feathersTertiaryLeft");
        ModelWingsAvian.add3DTexture(this.feathersTertiaryLeft, 10, 14, 0.0f, 0.0f, -0.5f, 10, 14);
        this.feathersSecondaryLeft = this.ulnaLeft.getChild("feathersSecondaryLeft");
        ModelWingsAvian.add3DTexture(this.feathersSecondaryLeft, 31, 14, -2.0f, 0.0f, -0.5f, 11, 12);
        this.feathersPrimaryLeft = this.carpalsLeft.getChild("feathersPrimaryLeft");
        ModelWingsAvian.add3DTexture(this.feathersPrimaryLeft, 53, 14, 0.0f, -2.1f, -0.5f, 11, 11);
        this.feathersCoracoidRight = this.coracoidRight.getChild("feathersCoracoidRight");
        ModelWingsAvian.add3DTexture(this.feathersCoracoidRight, 0, 40, -6.0f, 0.0f, -1.0f, 6, 8);
        this.feathersTertiaryRight = this.humerusRight.getChild("feathersTertiaryRight");
        ModelWingsAvian.add3DTexture(this.feathersTertiaryRight, 0, 14, -10.0f, 0.0f, -0.5f, 10, 14);
        this.feathersSecondaryRight = this.ulnaRight.getChild("feathersSecondaryRight");
        ModelWingsAvian.add3DTexture(this.feathersSecondaryRight, 20, 14, -9.0f, 0.0f, -0.5f, 11, 12);
        this.feathersPrimaryRight = this.carpalsRight.getChild("feathersPrimaryRight");
        ModelWingsAvian.add3DTexture(this.feathersPrimaryRight, 42, 14, -11.0f, -2.1f, -0.5f, 11, 11);
        this.bonesLeft = ImmutableList.of((Object)this.coracoidLeft, (Object)this.humerusLeft, (Object)this.ulnaLeft, (Object)this.carpalsLeft);
        this.bonesRight = ImmutableList.of((Object)this.coracoidRight, (Object)this.humerusRight, (Object)this.ulnaRight, (Object)this.carpalsRight);
        this.feathersLeft = ImmutableList.of((Object)this.feathersCoracoidLeft, (Object)this.feathersTertiaryLeft, (Object)this.feathersSecondaryLeft, (Object)this.feathersPrimaryLeft);
        this.feathersRight = ImmutableList.of((Object)this.feathersCoracoidRight, (Object)this.feathersTertiaryRight, (Object)this.feathersSecondaryRight, (Object)this.feathersPrimaryRight);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition coracoidLeft = root.addOrReplaceChild("coracoidLeft", CubeListBuilder.create().texOffs(0, 28).addBox(0.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)5.5f, (float)2.5f));
        PartDefinition coracoidRight = root.addOrReplaceChild("coracoidRight", CubeListBuilder.create().texOffs(0, 34).addBox(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)5.5f, (float)2.5f));
        PartDefinition humerusLeft = coracoidLeft.addOrReplaceChild("humerusLeft", CubeListBuilder.create().texOffs(0, 0).addBox(-0.1f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition humerusRight = coracoidRight.addOrReplaceChild("humerusRight", CubeListBuilder.create().texOffs(0, 7).addBox(-6.9f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition ulnaLeft = humerusLeft.addOrReplaceChild("ulnaLeft", CubeListBuilder.create().texOffs(22, 0).addBox(0.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.5f, (float)0.2f, (float)0.1f));
        PartDefinition ulnaRight = humerusRight.addOrReplaceChild("ulnaRight", CubeListBuilder.create().texOffs(22, 6).addBox(-9.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.5f, (float)0.2f, (float)0.1f));
        PartDefinition carpalsLeft = ulnaLeft.addOrReplaceChild("carpalsLeft", CubeListBuilder.create().texOffs(22, 0).addBox(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.5f, (float)0.0f, (float)0.0f));
        PartDefinition carpalsRight = ulnaRight.addOrReplaceChild("carpalsRight", CubeListBuilder.create().texOffs(22, 0).addBox(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.5f, (float)0.0f, (float)0.0f));
        coracoidLeft.addOrReplaceChild("feathersCoracoidLeft", CubeListBuilder.create(), PartPose.offset((float)0.4f, (float)0.0f, (float)1.0f));
        coracoidRight.addOrReplaceChild("feathersCoracoidRight", CubeListBuilder.create(), PartPose.offset((float)-0.4f, (float)0.0f, (float)1.0f));
        humerusLeft.addOrReplaceChild("feathersTertiaryLeft", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.5f, (float)1.0f));
        humerusRight.addOrReplaceChild("feathersTertiaryRight", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.5f, (float)1.0f));
        ulnaLeft.addOrReplaceChild("feathersSecondaryLeft", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        ulnaRight.addOrReplaceChild("feathersSecondaryRight", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        carpalsLeft.addOrReplaceChild("feathersPrimaryLeft", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        carpalsRight.addOrReplaceChild("feathersPrimaryRight", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static void add3DTexture(ModelPart model, int u, int v, float offX, float offY, float offZ, int width, int height) {
        ModelWingsAvian.getCubes(model).add(Model3DTexture.create(offX, offY, offZ, width, height, u, v, 64, 64));
    }

    private static Field findCubesField() {
        for (Field field : ModelPart.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !List.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            return field;
        }
        throw new IllegalStateException("Unable to locate ModelPart cubes field");
    }

    private static List<ModelPart.Cube> getCubes(ModelPart part) {
        try {
            List cubes = (List)CUBES_FIELD.get(part);
            ArrayList<ModelPart.Cube> mutable = new ArrayList<ModelPart.Cube>(cubes);
            CUBES_FIELD.set(part, mutable);
            return mutable;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void render(AnimatorAvian animator, float delta, PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ModelPart right;
        ModelPart left;
        int i;
        int color = ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue);
        for (i = 0; i < this.bonesLeft.size(); ++i) {
            left = (ModelPart)this.bonesLeft.get(i);
            right = (ModelPart)this.bonesRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getWingRotation(i, delta));
        }
        for (i = 0; i < this.feathersLeft.size(); ++i) {
            left = (ModelPart)this.feathersLeft.get(i);
            right = (ModelPart)this.feathersRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getFeatherRotation(i, delta));
        }
        this.coracoidLeft.render(matrixStack, buffer, packedLight, packedOverlay, color);
        this.coracoidRight.render(matrixStack, buffer, packedLight, packedOverlay, color);
    }
}

